/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.proxy.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.proxy.thrift.IteratorSetting;
import org.apache.accumulo.proxy.thrift.Range;
import org.apache.accumulo.proxy.thrift.ScanColumn;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class BatchScanOptions
implements TBase<BatchScanOptions, _Fields>,
Serializable,
Cloneable,
Comparable<BatchScanOptions> {
    private static final TStruct STRUCT_DESC = new TStruct("BatchScanOptions");
    private static final TField AUTHORIZATIONS_FIELD_DESC = new TField("authorizations", 14, 1);
    private static final TField RANGES_FIELD_DESC = new TField("ranges", 15, 2);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 3);
    private static final TField ITERATORS_FIELD_DESC = new TField("iterators", 15, 4);
    private static final TField THREADS_FIELD_DESC = new TField("threads", 8, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public Set<ByteBuffer> authorizations;
    public List<Range> ranges;
    public List<ScanColumn> columns;
    public List<IteratorSetting> iterators;
    public int threads;
    private static final int __THREADS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public BatchScanOptions() {
    }

    public BatchScanOptions(BatchScanOptions other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetAuthorizations()) {
            HashSet<ByteBuffer> __this__authorizations = new HashSet<ByteBuffer>(other.authorizations);
            this.authorizations = __this__authorizations;
        }
        if (other.isSetRanges()) {
            ArrayList<Range> __this__ranges = new ArrayList<Range>(other.ranges.size());
            for (Range range : other.ranges) {
                __this__ranges.add(new Range(range));
            }
            this.ranges = __this__ranges;
        }
        if (other.isSetColumns()) {
            ArrayList<ScanColumn> __this__columns = new ArrayList<ScanColumn>(other.columns.size());
            for (ScanColumn scanColumn : other.columns) {
                __this__columns.add(new ScanColumn(scanColumn));
            }
            this.columns = __this__columns;
        }
        if (other.isSetIterators()) {
            ArrayList<IteratorSetting> __this__iterators = new ArrayList<IteratorSetting>(other.iterators.size());
            for (IteratorSetting iteratorSetting : other.iterators) {
                __this__iterators.add(new IteratorSetting(iteratorSetting));
            }
            this.iterators = __this__iterators;
        }
        this.threads = other.threads;
    }

    public BatchScanOptions deepCopy() {
        return new BatchScanOptions(this);
    }

    public void clear() {
        this.authorizations = null;
        this.ranges = null;
        this.columns = null;
        this.iterators = null;
        this.setThreadsIsSet(false);
        this.threads = 0;
    }

    public int getAuthorizationsSize() {
        return this.authorizations == null ? 0 : this.authorizations.size();
    }

    public Iterator<ByteBuffer> getAuthorizationsIterator() {
        return this.authorizations == null ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
        if (this.authorizations == null) {
            this.authorizations = new HashSet<ByteBuffer>();
        }
        this.authorizations.add(elem);
    }

    public Set<ByteBuffer> getAuthorizations() {
        return this.authorizations;
    }

    public BatchScanOptions setAuthorizations(Set<ByteBuffer> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public void unsetAuthorizations() {
        this.authorizations = null;
    }

    public boolean isSetAuthorizations() {
        return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
        if (!value) {
            this.authorizations = null;
        }
    }

    public int getRangesSize() {
        return this.ranges == null ? 0 : this.ranges.size();
    }

    public Iterator<Range> getRangesIterator() {
        return this.ranges == null ? null : this.ranges.iterator();
    }

    public void addToRanges(Range elem) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<Range>();
        }
        this.ranges.add(elem);
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public BatchScanOptions setRanges(List<Range> ranges) {
        this.ranges = ranges;
        return this;
    }

    public void unsetRanges() {
        this.ranges = null;
    }

    public boolean isSetRanges() {
        return this.ranges != null;
    }

    public void setRangesIsSet(boolean value) {
        if (!value) {
            this.ranges = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<ScanColumn> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(ScanColumn elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ScanColumn>();
        }
        this.columns.add(elem);
    }

    public List<ScanColumn> getColumns() {
        return this.columns;
    }

    public BatchScanOptions setColumns(List<ScanColumn> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getIteratorsSize() {
        return this.iterators == null ? 0 : this.iterators.size();
    }

    public Iterator<IteratorSetting> getIteratorsIterator() {
        return this.iterators == null ? null : this.iterators.iterator();
    }

    public void addToIterators(IteratorSetting elem) {
        if (this.iterators == null) {
            this.iterators = new ArrayList<IteratorSetting>();
        }
        this.iterators.add(elem);
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public BatchScanOptions setIterators(List<IteratorSetting> iterators) {
        this.iterators = iterators;
        return this;
    }

    public void unsetIterators() {
        this.iterators = null;
    }

    public boolean isSetIterators() {
        return this.iterators != null;
    }

    public void setIteratorsIsSet(boolean value) {
        if (!value) {
            this.iterators = null;
        }
    }

    public int getThreads() {
        return this.threads;
    }

    public BatchScanOptions setThreads(int threads) {
        this.threads = threads;
        this.setThreadsIsSet(true);
        return this;
    }

    public void unsetThreads() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetThreads() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setThreadsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case AUTHORIZATIONS: {
                if (value == null) {
                    this.unsetAuthorizations();
                    break;
                }
                this.setAuthorizations((Set)value);
                break;
            }
            case RANGES: {
                if (value == null) {
                    this.unsetRanges();
                    break;
                }
                this.setRanges((List)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case ITERATORS: {
                if (value == null) {
                    this.unsetIterators();
                    break;
                }
                this.setIterators((List)value);
                break;
            }
            case THREADS: {
                if (value == null) {
                    this.unsetThreads();
                    break;
                }
                this.setThreads((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case AUTHORIZATIONS: {
                return this.getAuthorizations();
            }
            case RANGES: {
                return this.getRanges();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case ITERATORS: {
                return this.getIterators();
            }
            case THREADS: {
                return this.getThreads();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case AUTHORIZATIONS: {
                return this.isSetAuthorizations();
            }
            case RANGES: {
                return this.isSetRanges();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case ITERATORS: {
                return this.isSetIterators();
            }
            case THREADS: {
                return this.isSetThreads();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof BatchScanOptions) {
            return this.equals((BatchScanOptions)that);
        }
        return false;
    }

    public boolean equals(BatchScanOptions that) {
        if (that == null) {
            return false;
        }
        boolean this_present_authorizations = this.isSetAuthorizations();
        boolean that_present_authorizations = that.isSetAuthorizations();
        if (this_present_authorizations || that_present_authorizations) {
            if (!this_present_authorizations || !that_present_authorizations) {
                return false;
            }
            if (!this.authorizations.equals(that.authorizations)) {
                return false;
            }
        }
        boolean this_present_ranges = this.isSetRanges();
        boolean that_present_ranges = that.isSetRanges();
        if (this_present_ranges || that_present_ranges) {
            if (!this_present_ranges || !that_present_ranges) {
                return false;
            }
            if (!this.ranges.equals(that.ranges)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_iterators = this.isSetIterators();
        boolean that_present_iterators = that.isSetIterators();
        if (this_present_iterators || that_present_iterators) {
            if (!this_present_iterators || !that_present_iterators) {
                return false;
            }
            if (!this.iterators.equals(that.iterators)) {
                return false;
            }
        }
        boolean this_present_threads = this.isSetThreads();
        boolean that_present_threads = that.isSetThreads();
        if (this_present_threads || that_present_threads) {
            if (!this_present_threads || !that_present_threads) {
                return false;
            }
            if (this.threads != that.threads) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_authorizations = this.isSetAuthorizations();
        list.add(present_authorizations);
        if (present_authorizations) {
            list.add(this.authorizations);
        }
        boolean present_ranges = this.isSetRanges();
        list.add(present_ranges);
        if (present_ranges) {
            list.add(this.ranges);
        }
        boolean present_columns = this.isSetColumns();
        list.add(present_columns);
        if (present_columns) {
            list.add(this.columns);
        }
        boolean present_iterators = this.isSetIterators();
        list.add(present_iterators);
        if (present_iterators) {
            list.add(this.iterators);
        }
        boolean present_threads = this.isSetThreads();
        list.add(present_threads);
        if (present_threads) {
            list.add(this.threads);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(BatchScanOptions other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetAuthorizations()).compareTo(other.isSetAuthorizations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthorizations() && (lastComparison = TBaseHelper.compareTo(this.authorizations, other.authorizations)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRanges()).compareTo(other.isSetRanges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRanges() && (lastComparison = TBaseHelper.compareTo(this.ranges, other.ranges)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIterators()).compareTo(other.isSetIterators());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIterators() && (lastComparison = TBaseHelper.compareTo(this.iterators, other.iterators)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetThreads()).compareTo(other.isSetThreads());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetThreads() && (lastComparison = TBaseHelper.compareTo((int)this.threads, (int)other.threads)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BatchScanOptions(");
        boolean first = true;
        if (this.isSetAuthorizations()) {
            sb.append("authorizations:");
            if (this.authorizations == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString(this.authorizations, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetRanges()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ranges:");
            if (this.ranges == null) {
                sb.append("null");
            } else {
                sb.append(this.ranges);
            }
            first = false;
        }
        if (this.isSetColumns()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns:");
            if (this.columns == null) {
                sb.append("null");
            } else {
                sb.append(this.columns);
            }
            first = false;
        }
        if (this.isSetIterators()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("iterators:");
            if (this.iterators == null) {
                sb.append("null");
            } else {
                sb.append(this.iterators);
            }
            first = false;
        }
        if (this.isSetThreads()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("threads:");
            sb.append(this.threads);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new BatchScanOptionsStandardSchemeFactory());
        schemes.put(TupleScheme.class, new BatchScanOptionsTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.AUTHORIZATIONS, _Fields.RANGES, _Fields.COLUMNS, _Fields.ITERATORS, _Fields.THREADS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.AUTHORIZATIONS, new FieldMetaData("authorizations", 2, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.RANGES, new FieldMetaData("ranges", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Range.class))));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ScanColumn.class))));
        tmpMap.put(_Fields.ITERATORS, new FieldMetaData("iterators", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, IteratorSetting.class))));
        tmpMap.put(_Fields.THREADS, new FieldMetaData("threads", 2, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(BatchScanOptions.class, metaDataMap);
    }

    private static class BatchScanOptionsTupleScheme
    extends TupleScheme<BatchScanOptions> {
        private BatchScanOptionsTupleScheme() {
        }

        public void write(TProtocol prot, BatchScanOptions struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetAuthorizations()) {
                optionals.set(0);
            }
            if (struct.isSetRanges()) {
                optionals.set(1);
            }
            if (struct.isSetColumns()) {
                optionals.set(2);
            }
            if (struct.isSetIterators()) {
                optionals.set(3);
            }
            if (struct.isSetThreads()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetAuthorizations()) {
                oprot.writeI32(struct.authorizations.size());
                for (ByteBuffer _iter66 : struct.authorizations) {
                    oprot.writeBinary(_iter66);
                }
            }
            if (struct.isSetRanges()) {
                oprot.writeI32(struct.ranges.size());
                for (Range _iter67 : struct.ranges) {
                    _iter67.write((TProtocol)oprot);
                }
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (ScanColumn _iter68 : struct.columns) {
                    _iter68.write((TProtocol)oprot);
                }
            }
            if (struct.isSetIterators()) {
                oprot.writeI32(struct.iterators.size());
                for (IteratorSetting _iter69 : struct.iterators) {
                    _iter69.write((TProtocol)oprot);
                }
            }
            if (struct.isSetThreads()) {
                oprot.writeI32(struct.threads);
            }
        }

        public void read(TProtocol prot, BatchScanOptions struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                TSet _set70 = new TSet(11, iprot.readI32());
                struct.authorizations = new HashSet<ByteBuffer>(2 * _set70.size);
                for (int _i72 = 0; _i72 < _set70.size; ++_i72) {
                    ByteBuffer _elem71 = iprot.readBinary();
                    struct.authorizations.add(_elem71);
                }
                struct.setAuthorizationsIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list73 = new TList(12, iprot.readI32());
                struct.ranges = new ArrayList<Range>(_list73.size);
                for (int _i75 = 0; _i75 < _list73.size; ++_i75) {
                    Range _elem74 = new Range();
                    _elem74.read((TProtocol)iprot);
                    struct.ranges.add(_elem74);
                }
                struct.setRangesIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list76 = new TList(12, iprot.readI32());
                struct.columns = new ArrayList<ScanColumn>(_list76.size);
                for (int _i78 = 0; _i78 < _list76.size; ++_i78) {
                    ScanColumn _elem77 = new ScanColumn();
                    _elem77.read((TProtocol)iprot);
                    struct.columns.add(_elem77);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list79 = new TList(12, iprot.readI32());
                struct.iterators = new ArrayList<IteratorSetting>(_list79.size);
                for (int _i81 = 0; _i81 < _list79.size; ++_i81) {
                    IteratorSetting _elem80 = new IteratorSetting();
                    _elem80.read((TProtocol)iprot);
                    struct.iterators.add(_elem80);
                }
                struct.setIteratorsIsSet(true);
            }
            if (incoming.get(4)) {
                struct.threads = iprot.readI32();
                struct.setThreadsIsSet(true);
            }
        }
    }

    private static class BatchScanOptionsTupleSchemeFactory
    implements SchemeFactory {
        private BatchScanOptionsTupleSchemeFactory() {
        }

        public BatchScanOptionsTupleScheme getScheme() {
            return new BatchScanOptionsTupleScheme();
        }
    }

    private static class BatchScanOptionsStandardScheme
    extends StandardScheme<BatchScanOptions> {
        private BatchScanOptionsStandardScheme() {
        }

        public void read(TProtocol iprot, BatchScanOptions struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 14) {
                            TSet _set50 = iprot.readSetBegin();
                            struct.authorizations = new HashSet<ByteBuffer>(2 * _set50.size);
                            for (int _i52 = 0; _i52 < _set50.size; ++_i52) {
                                ByteBuffer _elem51 = iprot.readBinary();
                                struct.authorizations.add(_elem51);
                            }
                            iprot.readSetEnd();
                            struct.setAuthorizationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list53 = iprot.readListBegin();
                            struct.ranges = new ArrayList<Range>(_list53.size);
                            for (int _i55 = 0; _i55 < _list53.size; ++_i55) {
                                Range _elem54 = new Range();
                                _elem54.read(iprot);
                                struct.ranges.add(_elem54);
                            }
                            iprot.readListEnd();
                            struct.setRangesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list56 = iprot.readListBegin();
                            struct.columns = new ArrayList<ScanColumn>(_list56.size);
                            for (int _i58 = 0; _i58 < _list56.size; ++_i58) {
                                ScanColumn _elem57 = new ScanColumn();
                                _elem57.read(iprot);
                                struct.columns.add(_elem57);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list59 = iprot.readListBegin();
                            struct.iterators = new ArrayList<IteratorSetting>(_list59.size);
                            for (int _i61 = 0; _i61 < _list59.size; ++_i61) {
                                IteratorSetting _elem60 = new IteratorSetting();
                                _elem60.read(iprot);
                                struct.iterators.add(_elem60);
                            }
                            iprot.readListEnd();
                            struct.setIteratorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.threads = iprot.readI32();
                            struct.setThreadsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, BatchScanOptions struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.authorizations != null && struct.isSetAuthorizations()) {
                oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(11, struct.authorizations.size()));
                for (ByteBuffer _iter62 : struct.authorizations) {
                    oprot.writeBinary(_iter62);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.ranges != null && struct.isSetRanges()) {
                oprot.writeFieldBegin(RANGES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.ranges.size()));
                for (Range _iter63 : struct.ranges) {
                    _iter63.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.columns != null && struct.isSetColumns()) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (ScanColumn _iter64 : struct.columns) {
                    _iter64.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.iterators != null && struct.isSetIterators()) {
                oprot.writeFieldBegin(ITERATORS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.iterators.size()));
                for (IteratorSetting _iter65 : struct.iterators) {
                    _iter65.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetThreads()) {
                oprot.writeFieldBegin(THREADS_FIELD_DESC);
                oprot.writeI32(struct.threads);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class BatchScanOptionsStandardSchemeFactory
    implements SchemeFactory {
        private BatchScanOptionsStandardSchemeFactory() {
        }

        public BatchScanOptionsStandardScheme getScheme() {
            return new BatchScanOptionsStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        AUTHORIZATIONS(1, "authorizations"),
        RANGES(2, "ranges"),
        COLUMNS(3, "columns"),
        ITERATORS(4, "iterators"),
        THREADS(5, "threads");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return AUTHORIZATIONS;
                }
                case 2: {
                    return RANGES;
                }
                case 3: {
                    return COLUMNS;
                }
                case 4: {
                    return ITERATORS;
                }
                case 5: {
                    return THREADS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

