/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.start.spi.KeywordExecutable;

public class CreateToken
implements KeywordExecutable {
    private ConsoleReader reader = null;

    private ConsoleReader getConsoleReader() throws IOException {
        if (this.reader == null) {
            this.reader = new ConsoleReader();
        }
        return this.reader;
    }

    public static void main(String[] args) {
        new CreateToken().execute(args);
    }

    public String keyword() {
        return "create-token";
    }

    public void execute(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(CreateToken.class.getName(), args, new Object[0]);
        ClientOpts.Password pass = opts.password;
        if (pass == null && opts.securePassword != null) {
            pass = opts.securePassword;
        }
        try {
            File tf;
            String principal = opts.principal;
            if (principal == null) {
                principal = this.getConsoleReader().readLine("Username (aka principal): ");
            }
            AuthenticationToken token = Class.forName(opts.tokenClassName).asSubclass(AuthenticationToken.class).newInstance();
            AuthenticationToken.Properties props = new AuthenticationToken.Properties();
            for (AuthenticationToken.TokenProperty tp : token.getProperties()) {
                String input = pass != null && tp.getKey().equals("password") ? pass.toString() : (tp.getMask() ? this.getConsoleReader().readLine(tp.getDescription() + ": ", Character.valueOf('*')) : this.getConsoleReader().readLine(tp.getDescription() + ": "));
                props.put(tp.getKey(), input);
                token.init(props);
            }
            String tokenBase64 = Base64.getEncoder().encodeToString(AuthenticationToken.AuthenticationTokenSerializer.serialize(token));
            String tokenFile = opts.tokenFile;
            if (tokenFile == null) {
                tokenFile = this.getConsoleReader().readLine("File to save auth token to: ");
            }
            if (!(tf = new File(tokenFile)).exists() && !tf.createNewFile()) {
                throw new IOException("Couldn't create " + tf.getCanonicalPath());
            }
            PrintStream out = new PrintStream((OutputStream)new FileOutputStream(tf, true), true, StandardCharsets.UTF_8.name());
            String outString = principal + ":" + opts.tokenClassName + ":" + tokenBase64;
            out.println(outString);
            out.close();
            System.out.println("Token written to " + tokenFile + ". Remember to upload it to hdfs.");
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-u", "--user"}, description="Connection user")
        public String principal = null;
        @Parameter(names={"-p"}, converter=ClientOpts.PasswordConverter.class, description="Connection password")
        public ClientOpts.Password password = null;
        @Parameter(names={"--password"}, converter=ClientOpts.PasswordConverter.class, description="Enter the connection password", password=true)
        public ClientOpts.Password securePassword = null;
        @Parameter(names={"-tc", "--tokenClass"}, description="The class of the authentication token")
        public String tokenClassName = PasswordToken.class.getName();
        @Parameter(names={"-f", "--file"}, description="The filename to save the auth token to. Multiple tokens can be stored in the same file, but only the first for each user will be recognized.")
        public String tokenFile = null;

        Opts() {
        }
    }
}

