/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.common.base.Predicate;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

@SuppressModernizer
public abstract class Validator<T>
implements Predicate<T> {
    public final T validate(T argument) {
        if (!this.apply(argument)) {
            throw new IllegalArgumentException(this.invalidMessage(argument));
        }
        return argument;
    }

    public String invalidMessage(T argument) {
        return String.format("Invalid argument %s", argument);
    }

    public final Validator<T> and(final Validator<T> other) {
        if (other == null) {
            return this;
        }
        final Validator mine = this;
        return new Validator<T>(){

            public boolean apply(T argument) {
                return mine.apply(argument) && other.apply(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return (mine.apply(argument) ? other : mine).invalidMessage(argument);
            }
        };
    }

    public final Validator<T> or(final Validator<T> other) {
        if (other == null) {
            return this;
        }
        final Validator mine = this;
        return new Validator<T>(){

            public boolean apply(T argument) {
                return mine.apply(argument) || other.apply(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return mine.invalidMessage(argument);
            }
        };
    }

    public final Validator<T> not() {
        final Validator mine = this;
        return new Validator<T>(){

            public boolean apply(T argument) {
                return !mine.apply(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return "Validation should have failed with: " + mine.invalidMessage(argument);
            }
        };
    }
}

