/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util.time;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTimer {
    private static final Logger log = LoggerFactory.getLogger(SimpleTimer.class);
    private static int instanceThreadPoolSize = -1;
    private static SimpleTimer instance;
    private ScheduledExecutorService executor;
    private static final int DEFAULT_THREAD_POOL_SIZE = 1;

    public static synchronized SimpleTimer getInstance(int threadPoolSize) {
        if (instance == null) {
            instance = new SimpleTimer(threadPoolSize);
            instanceThreadPoolSize = threadPoolSize;
        } else if (instanceThreadPoolSize != threadPoolSize) {
            log.warn("Asked to create SimpleTimer with thread pool size " + threadPoolSize + ", existing instance has " + instanceThreadPoolSize);
        }
        return instance;
    }

    public static synchronized SimpleTimer getInstance(AccumuloConfiguration conf) {
        int threadPoolSize = conf != null ? conf.getCount(Property.GENERAL_SIMPLETIMER_THREADPOOL_SIZE) : 1;
        return SimpleTimer.getInstance(threadPoolSize);
    }

    @VisibleForTesting
    static int getInstanceThreadPoolSize() {
        return instanceThreadPoolSize;
    }

    private SimpleTimer(int threadPoolSize) {
        this.executor = Executors.newScheduledThreadPool(threadPoolSize, new ThreadFactoryBuilder().setNameFormat("SimpleTimer-%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ExceptionHandler()).build());
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        return this.executor.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, long period) {
        return this.executor.scheduleWithFixedDelay(task, delay, period, TimeUnit.MILLISECONDS);
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.warn("SimpleTimer task failed", e);
        }
    }
}

