/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics.fate;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FateMetricSnapshot {
    private static final Logger log = LoggerFactory.getLogger(FateMetricSnapshot.class);
    private final long updateTime;
    private final long currentFateOps;
    private final long zkFateChildOpsTotal;
    private final long zkConnectionErrors;
    private final Map<String, Long> txStateCounters;
    private final Map<String, Long> opTypeCounters;

    private FateMetricSnapshot(long updateTime, long currentFateOps, long zkFateChildOpsTotal, long zkConnectionErrors, Map<String, Long> txStateCounters, Map<String, Long> opTypeCounters) {
        this.updateTime = updateTime;
        this.currentFateOps = currentFateOps;
        this.zkFateChildOpsTotal = zkFateChildOpsTotal;
        this.zkConnectionErrors = zkConnectionErrors;
        this.txStateCounters = txStateCounters;
        this.opTypeCounters = opTypeCounters;
    }

    public static FateMetricSnapshot getFromZooKeeper(String instanceId, ZooReaderWriter zoo) {
        Builder builder = FateMetricSnapshot.builder();
        AdminUtil admin = new AdminUtil(false);
        try {
            ZooStore zs = new ZooStore(ZooUtil.getRoot((String)instanceId) + "/fate", (IZooReaderWriter)zoo);
            List currFates = admin.getTransactionStatus((ReadOnlyTStore)zs, null, null);
            builder.withCurrentFateOps(currFates.size());
            Stat node = zoo.getZooKeeper().exists(ZooUtil.getRoot((String)instanceId) + "/fate", false);
            builder.withZkFateChildOpsTotal(node.getCversion());
            if (log.isTraceEnabled()) {
                log.trace("ZkNodeStat: {czxid: {}, mzxid: {}, pzxid: {}, ctime: {}, mtime: {}, version: {}, cversion: {}, num children: {}", new Object[]{node.getCzxid(), node.getMzxid(), node.getPzxid(), node.getCtime(), node.getMtime(), node.getVersion(), node.getCversion(), node.getNumChildren()});
            }
            TreeMap<String, Long> states = new TreeMap<String, Long>();
            for (ReadOnlyTStore.TStatus t : ReadOnlyTStore.TStatus.values()) {
                states.put(t.name(), 0L);
            }
            TreeMap<String, Long> opTypeCounters = new TreeMap<String, Long>();
            for (AdminUtil.TransactionStatus tx : currFates) {
                String stateName = tx.getStatus().name();
                states.merge(stateName, 1L, Long::sum);
                if (!ReadOnlyTStore.TStatus.IN_PROGRESS.equals((Object)tx.getStatus())) continue;
                String opType = tx.getDebug();
                if (opType == null || opType.isEmpty()) {
                    opType = "UNKNOWN";
                }
                opTypeCounters.merge(opType, 1L, Long::sum);
            }
            builder.withTxStateCounters(states);
            builder.withOpTypeCounters(opTypeCounters);
        }
        catch (KeeperException ex) {
            log.debug("Error connecting to ZooKeeper", (Throwable)ex);
            builder.incrZkConnectionErrors();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return builder.build();
    }

    long getCurrentFateOps() {
        return this.currentFateOps;
    }

    long getZkFateChildOpsTotal() {
        return this.zkFateChildOpsTotal;
    }

    long getZkConnectionErrors() {
        return this.zkConnectionErrors;
    }

    Map<String, Long> getTxStateCounters() {
        return this.txStateCounters;
    }

    Map<String, Long> getOpTypeCounters() {
        return this.opTypeCounters;
    }

    public String toString() {
        return new StringJoiner(", ", FateMetricSnapshot.class.getSimpleName() + "[", "]").add("updateTime=" + this.updateTime).add("currentFateOps=" + this.currentFateOps).add("zkFateChildOpsTotal=" + this.zkFateChildOpsTotal).add("zkConnectionErrors=" + this.zkConnectionErrors).add("txStateCounters=" + this.txStateCounters).add("opTypeCounters=" + this.opTypeCounters).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private long currentFateOps = 0L;
        private long zkFateChildOpsTotal = 0L;
        private long zkConnectionErrors = 0L;
        private final Map<String, Long> txStateCounters = new TreeMap<String, Long>();
        private Map<String, Long> opTypeCounters;

        Builder() {
            for (ReadOnlyTStore.TStatus t : ReadOnlyTStore.TStatus.values()) {
                this.txStateCounters.put(t.name(), 0L);
            }
            this.opTypeCounters = Collections.emptyMap();
        }

        Builder copy(FateMetricSnapshot v) {
            if (Objects.isNull(v)) {
                return this;
            }
            this.withCurrentFateOps(v.getCurrentFateOps());
            this.withZkFateChildOpsTotal(v.getZkFateChildOpsTotal());
            this.withZkConnectionErrors(v.getZkConnectionErrors());
            this.withTxStateCounters(v.getTxStateCounters());
            this.withOpTypeCounters(v.getOpTypeCounters());
            return this;
        }

        Builder withCurrentFateOps(long value) {
            this.currentFateOps = value;
            return this;
        }

        Builder withZkFateChildOpsTotal(long value) {
            this.zkFateChildOpsTotal = value;
            return this;
        }

        Builder incrZkConnectionErrors() {
            ++this.zkConnectionErrors;
            return this;
        }

        Builder withZkConnectionErrors(long value) {
            this.zkConnectionErrors = value;
            return this;
        }

        Builder withTxStateCounters(Map<String, Long> txStateCounters) {
            this.txStateCounters.putAll(txStateCounters);
            return this;
        }

        Builder withOpTypeCounters(Map<String, Long> opTypeCounters) {
            this.opTypeCounters = new TreeMap<String, Long>(opTypeCounters);
            return this;
        }

        FateMetricSnapshot build() {
            return new FateMetricSnapshot(System.currentTimeMillis(), this.currentFateOps, this.zkFateChildOpsTotal, this.zkConnectionErrors, this.txStateCounters, this.opTypeCounters);
        }
    }
}

