/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.slf4j.LoggerFactory;

public class RenameTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String namespaceId;
    private String oldTableName;
    private String newTableName;

    private String getNamespaceId(Master env) throws Exception {
        return Utils.getNamespaceId(env.getInstance(), this.tableId, TableOperation.RENAME, this.namespaceId);
    }

    @Override
    public long isReady(long tid, Master env) throws Exception {
        return Utils.reserveNamespace(this.getNamespaceId(env), tid, false, true, TableOperation.RENAME) + Utils.reserveTable(this.tableId, tid, true, true, TableOperation.RENAME);
    }

    public RenameTable(String namespaceId, String tableId, String oldTableName, String newTableName) throws NamespaceNotFoundException {
        this.namespaceId = namespaceId;
        this.tableId = tableId;
        this.oldTableName = oldTableName;
        this.newTableName = newTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Instance instance = master.getInstance();
        String namespaceId = this.getNamespaceId(master);
        Pair qualifiedOldTableName = Tables.qualify((String)this.oldTableName);
        Pair qualifiedNewTableName = Tables.qualify((String)this.newTableName);
        if (this.newTableName.contains(".") && !namespaceId.equals(Namespaces.getNamespaceId((Instance)instance, (String)((String)qualifiedNewTableName.getFirst())))) {
            throw new AcceptableThriftTableOperationException(this.tableId, this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.INVALID_NAME, "Namespace in new table name does not match the old table name");
        }
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        Utils.tableNameLock.lock();
        try {
            Utils.checkTableDoesNotExist(instance, this.newTableName, this.tableId, TableOperation.RENAME);
            final String newName = (String)qualifiedNewTableName.getSecond();
            final String oldName = (String)qualifiedOldTableName.getSecond();
            String tap = ZooUtil.getRoot((Instance)instance) + "/tables" + "/" + this.tableId + "/name";
            zoo.mutate(tap, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] current) throws Exception {
                    String currentName = new String(current, StandardCharsets.UTF_8);
                    if (currentName.equals(newName)) {
                        return null;
                    }
                    if (!currentName.equals(oldName)) {
                        throw new AcceptableThriftTableOperationException(null, RenameTable.this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.NOTFOUND, "Name changed while processing");
                    }
                    return newName.getBytes(StandardCharsets.UTF_8);
                }
            });
            Tables.clearCache((Instance)instance);
        }
        finally {
            Utils.tableNameLock.unlock();
            Utils.unreserveTable(this.tableId, tid, true);
            Utils.unreserveNamespace(namespaceId, tid, false);
        }
        LoggerFactory.getLogger(RenameTable.class).debug("Renamed table " + this.tableId + " " + this.oldTableName + " " + this.newTableName);
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveTable(this.tableId, tid, true);
        Utils.unreserveNamespace(this.getNamespaceId(env), tid, false);
    }
}

