/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import org.apache.accumulo.core.cli.MapReduceClientOnRequiredTable;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordCount
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(WordCount.class);

    public int run(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(WordCount.class.getName(), args, new Object[0]);
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(WordCount.class.getName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(TextInputFormat.class);
        TextInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(opts.inputDirectory)});
        job.setMapperClass(MapClass.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Mutation.class);
        opts.setAccumuloConfigs(job);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new WordCount(), (String[])args);
    }

    public static class MapClass
    extends Mapper<LongWritable, Text, Text, Mutation> {
        public void map(LongWritable key, Text value, Mapper.Context output) throws IOException {
            String[] words;
            for (String word : words = value.toString().split("\\s+")) {
                Mutation mutation = new Mutation(new Text(word));
                mutation.put(new Text("count"), new Text("20080906"), new Value("1".getBytes()));
                try {
                    output.write(null, (Object)mutation);
                }
                catch (InterruptedException e) {
                    log.error("Could not write mutation to Context.", (Throwable)e);
                }
            }
        }
    }

    static class Opts
    extends MapReduceClientOnRequiredTable {
        @Parameter(names={"--input"}, description="input directory")
        String inputDirectory;

        Opts() {
        }
    }
}

