/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.iterators.system.StatsIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.FileManager;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.TabletIteratorEnvironment;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.tablet.ScanOptions;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletClosedException;

class ScanDataSource
implements SourceSwitchingIterator.DataSource {
    private final Tablet tablet;
    private FileManager.ScanFileManager fileManager;
    private SortedKeyValueIterator<Key, Value> iter;
    private long expectedDeletionCount;
    private List<InMemoryMap.MemoryIterator> memIters = null;
    private long fileReservationId;
    private AtomicBoolean interruptFlag;
    private StatsIterator statsIterator;
    private final ScanOptions options;
    private final boolean loadIters;
    private static final Set<Column> EMPTY_COLS = Collections.emptySet();

    ScanDataSource(Tablet tablet, Authorizations authorizations, byte[] defaultLabels, HashSet<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag, SamplerConfiguration samplerConfig, long batchTimeOut, String context) {
        this.tablet = tablet;
        this.expectedDeletionCount = tablet.getDataSourceDeletions();
        this.options = new ScanOptions(-1, authorizations, defaultLabels, columnSet, ssiList, ssio, interruptFlag, false, samplerConfig, batchTimeOut, context);
        this.interruptFlag = interruptFlag;
        this.loadIters = true;
    }

    ScanDataSource(Tablet tablet, ScanOptions options) {
        this.tablet = tablet;
        this.expectedDeletionCount = tablet.getDataSourceDeletions();
        this.options = options;
        this.interruptFlag = options.getInterruptFlag();
        this.loadIters = true;
    }

    ScanDataSource(Tablet tablet, Authorizations authorizations, byte[] defaultLabels, AtomicBoolean iFlag) {
        this.tablet = tablet;
        this.expectedDeletionCount = tablet.getDataSourceDeletions();
        this.options = new ScanOptions(-1, authorizations, defaultLabels, EMPTY_COLS, null, null, iFlag, false, null, -1L, null);
        this.interruptFlag = iFlag;
        this.loadIters = false;
    }

    public SourceSwitchingIterator.DataSource getNewDataSource() {
        if (!this.isCurrent()) {
            if (this.memIters != null) {
                this.tablet.getTabletMemory().returnIterators(this.memIters);
                this.memIters = null;
                this.tablet.getDatafileManager().returnFilesForScan(this.fileReservationId);
                this.fileReservationId = -1L;
            }
            if (this.fileManager != null) {
                this.fileManager.releaseOpenFiles(false);
            }
            this.expectedDeletionCount = this.tablet.getDataSourceDeletions();
            this.iter = null;
            return this;
        }
        return this;
    }

    public boolean isCurrent() {
        return this.expectedDeletionCount == this.tablet.getDataSourceDeletions();
    }

    public SortedKeyValueIterator<Key, Value> iterator() throws IOException {
        if (this.iter == null) {
            this.iter = this.createIterator();
        }
        return this.iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedKeyValueIterator<Key, Value> createIterator() throws IOException {
        HashMap iterOpts;
        ArrayList iterInfos;
        Map files;
        SamplerConfigurationImpl samplerConfig = this.options.getSamplerConfigurationImpl();
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            if (this.memIters != null) {
                throw new IllegalStateException("Tried to create new scan iterator w/o releasing memory");
            }
            if (this.tablet.isClosed()) {
                throw new TabletClosedException();
            }
            if (this.interruptFlag.get()) {
                throw new IterationInterruptedException(this.tablet.getExtent().toString() + " " + this.interruptFlag.hashCode());
            }
            if (this.fileManager == null) {
                this.fileManager = this.tablet.getTabletResources().newScanFileManager();
                this.tablet.addActiveScans(this);
            }
            if (this.fileManager.getNumOpenFiles() != 0) {
                throw new IllegalStateException("Tried to create new scan iterator w/o releasing files");
            }
            this.expectedDeletionCount = this.tablet.getDataSourceDeletions();
            this.memIters = this.tablet.getTabletMemory().getIterators(samplerConfig);
            Pair<Long, Map<FileRef, DataFileValue>> reservation = this.tablet.getDatafileManager().reserveFilesForScan();
            this.fileReservationId = (Long)reservation.getFirst();
            files = (Map)reservation.getSecond();
        }
        List<InterruptibleIterator> mapfiles = this.fileManager.openFiles(files, this.options.isIsolated(), samplerConfig);
        for (SortedKeyValueIterator skvi : Iterables.concat(mapfiles, this.memIters)) {
            ((InterruptibleIterator)skvi).setInterruptFlag(this.interruptFlag);
        }
        ArrayList<InterruptibleIterator> iters = new ArrayList<InterruptibleIterator>(mapfiles.size() + this.memIters.size());
        iters.addAll(mapfiles);
        iters.addAll(this.memIters);
        MultiIterator multiIter = new MultiIterator(iters, this.tablet.getExtent());
        TabletIteratorEnvironment iterEnv = new TabletIteratorEnvironment(IteratorUtil.IteratorScope.scan, (AccumuloConfiguration)this.tablet.getTableConfiguration(), this.fileManager, files, this.options.getAuthorizations(), samplerConfig);
        this.statsIterator = new StatsIterator((SortedKeyValueIterator)multiIter, TabletServer.seekCount, this.tablet.getScannedCounter());
        SortedKeyValueIterator visFilter = IteratorUtil.setupSystemScanIterators((SortedKeyValueIterator)this.statsIterator, this.options.getColumnSet(), (Authorizations)this.options.getAuthorizations(), (byte[])this.options.getDefaultLabels());
        if (!this.loadIters) {
            return visFilter;
        }
        TableConfiguration.ParsedIteratorConfig pic = this.tablet.getTableConfiguration().getParsedIteratorConfig(IteratorUtil.IteratorScope.scan);
        if (this.options.getSsiList().size() == 0 && this.options.getSsio().size() == 0) {
            iterInfos = pic.getIterInfo();
            iterOpts = pic.getOpts();
        } else {
            iterOpts = new HashMap(pic.getOpts().size() + this.options.getSsio().size());
            iterInfos = new ArrayList(pic.getIterInfo().size() + this.options.getSsiList().size());
            IteratorUtil.mergeIteratorConfig(iterInfos, iterOpts, (List)pic.getIterInfo(), (Map)pic.getOpts(), this.options.getSsiList(), this.options.getSsio());
        }
        String context = this.options.getClassLoaderContext() != null ? this.options.getClassLoaderContext() : pic.getContext();
        return iterEnv.getTopLevelIterator((SortedKeyValueIterator<Key, Value>)IteratorUtil.loadIterators((SortedKeyValueIterator)visFilter, iterInfos, iterOpts, (IteratorEnvironment)iterEnv, (boolean)true, (String)context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean sawErrors) {
        if (this.memIters != null) {
            this.tablet.getTabletMemory().returnIterators(this.memIters);
            this.memIters = null;
            this.tablet.getDatafileManager().returnFilesForScan(this.fileReservationId);
            this.fileReservationId = -1L;
        }
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            if (this.tablet.removeScan(this) == 0) {
                this.tablet.notifyAll();
            }
        }
        if (this.fileManager != null) {
            this.fileManager.releaseOpenFiles(sawErrors);
            this.fileManager = null;
        }
        if (this.statsIterator != null) {
            this.statsIterator.report();
        }
    }

    public void interrupt() {
        this.interruptFlag.set(true);
    }

    public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public void reattachFileManager() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.reattach(this.options.getSamplerConfigurationImpl());
        }
    }

    public void detachFileManager() {
        if (this.fileManager != null) {
            this.fileManager.detach();
        }
    }

    public void setInterruptFlag(AtomicBoolean flag) {
        throw new UnsupportedOperationException();
    }
}

