/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tracer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.tracer.SpanTreeVisitor;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.accumulo.tracer.thrift.RemoteSpan;

public class SpanTree {
    final Map<Long, List<Long>> parentChildren = new HashMap<Long, List<Long>>();
    public final Map<Long, RemoteSpan> nodes = new HashMap<Long, RemoteSpan>();

    public void addNode(RemoteSpan span2) {
        this.nodes.put(span2.spanId, span2);
        if (this.parentChildren.get(span2.parentId) == null) {
            this.parentChildren.put(span2.parentId, new ArrayList());
        }
        this.parentChildren.get(span2.parentId).add(span2.spanId);
    }

    public Set<Long> visit(SpanTreeVisitor visitor) {
        HashSet<Long> visited = new HashSet<Long>();
        List<Long> root = this.parentChildren.get(477902L);
        if (root == null || root.isEmpty()) {
            return visited;
        }
        RemoteSpan rootSpan = this.nodes.get(root.iterator().next());
        if (rootSpan == null) {
            return visited;
        }
        this.recurse(0, null, rootSpan, visitor, visited);
        return visited;
    }

    private void recurse(int level, RemoteSpan parent, RemoteSpan node, SpanTreeVisitor visitor, Set<Long> visited) {
        if (visited.contains(node.spanId)) {
            return;
        }
        visited.add(node.spanId);
        List<RemoteSpan> children = new ArrayList<RemoteSpan>();
        List<Long> childrenIds = this.parentChildren.get(node.spanId);
        if (childrenIds != null) {
            for (Long childId : childrenIds) {
                RemoteSpan child = this.nodes.get(childId);
                if (child == null) continue;
                children.add(child);
            }
        }
        children = TraceDump.sortByStart(children);
        visitor.visit(level, parent, node, children);
        for (RemoteSpan child : children) {
            this.recurse(level + 1, node, child, visitor, visited);
        }
    }
}

