/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tracer;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.tracer.SpanTree;
import org.apache.accumulo.tracer.SpanTreeVisitor;
import org.apache.accumulo.tracer.TraceFormatter;
import org.apache.accumulo.tracer.thrift.RemoteSpan;
import org.apache.hadoop.io.Text;

public class TraceDump {
    static final long DEFAULT_TIME_IN_MILLIS = 600000L;

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(TraceDump.class.getName(), args, new Object[]{scanOpts});
        int code = 0;
        if (opts.list) {
            code = TraceDump.listSpans(opts, scanOpts);
        }
        if (code == 0 && opts.dump) {
            code = TraceDump.dumpTrace(opts, scanOpts);
        }
        System.exit(code);
    }

    public static List<RemoteSpan> sortByStart(Collection<RemoteSpan> spans) {
        ArrayList<RemoteSpan> spanList = new ArrayList<RemoteSpan>(spans);
        Collections.sort(spanList, new Comparator<RemoteSpan>(){

            @Override
            public int compare(RemoteSpan o1, RemoteSpan o2) {
                return (int)(o1.start - o2.start);
            }
        });
        return spanList;
    }

    private static int listSpans(Opts opts, ScannerOpts scanOpts) throws Exception {
        PrintStream out = System.out;
        long endTime = System.currentTimeMillis();
        long startTime = endTime - opts.length;
        Connector conn = opts.getConnector();
        Scanner scanner = conn.createScanner(opts.getTableName(), opts.auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        Range range = new Range(new Text("start:" + Long.toHexString(startTime)), new Text("start:" + Long.toHexString(endTime)));
        scanner.setRange(range);
        out.println("Trace            Day/Time                 (ms)  Start");
        for (Map.Entry entry : scanner) {
            RemoteSpan span2 = TraceFormatter.getRemoteSpan(entry);
            out.println(String.format("%016x %s %5d %s", span2.traceId, TraceFormatter.formatDate(new Date(span2.getStart())), span2.stop - span2.start, span2.description));
        }
        return 0;
    }

    private static int dumpTrace(Opts opts, ScannerOpts scanOpts) throws Exception {
        final PrintStream out = System.out;
        Connector conn = opts.getConnector();
        int count = 0;
        for (String traceId : opts.traceIds) {
            Scanner scanner = conn.createScanner(opts.getTableName(), opts.auths);
            scanner.setBatchSize(scanOpts.scanBatchSize);
            Range range = new Range(new Text(traceId.toString()));
            scanner.setRange(range);
            count = TraceDump.printTrace(scanner, new Printer(){

                @Override
                public void print(String line) {
                    out.println(line);
                }
            });
        }
        return count > 0 ? 0 : 1;
    }

    public static int printTrace(Scanner scanner, final Printer out) {
        int count = 0;
        SpanTree tree = new SpanTree();
        long start = Long.MAX_VALUE;
        for (Map.Entry entry : scanner) {
            RemoteSpan span2 = TraceFormatter.getRemoteSpan(entry);
            tree.addNode(span2);
            start = Math.min(start, span2.start);
            if (span2.parentId != 477902L) continue;
            ++count;
        }
        if (Long.MAX_VALUE == start) {
            out.print("Did not find any traces!");
            return 0;
        }
        out.print(String.format("Trace started at %s", TraceFormatter.formatDate(new Date(start))));
        out.print("Time  Start  Service@Location       Name");
        final long finalStart = start;
        Set<Long> visited = tree.visit(new SpanTreeVisitor(){

            @Override
            public void visit(int level, RemoteSpan parent, RemoteSpan node, Collection<RemoteSpan> children) {
                String fmt = "%5d+%-5d %" + (level * 2 + 1) + "s%s@%s %s";
                out.print(String.format(fmt, node.stop - node.start, node.start - finalStart, "", node.svc, node.sender, node.description));
            }
        });
        tree.nodes.keySet().removeAll(visited);
        if (!tree.nodes.isEmpty()) {
            out.print("The following spans are not rooted (probably due to a parent span of length 0ms):");
            for (RemoteSpan span3 : TraceDump.sortByStart(tree.nodes.values())) {
                String fmt = "%5d+%-5d %1s%s@%s %s";
                out.print(String.format(fmt, span3.stop - span3.start, span3.start - finalStart, "", span3.svc, span3.sender, span3.description));
            }
            return -1;
        }
        return count;
    }

    public static interface Printer {
        public void print(String var1);
    }

    static class Opts
    extends ClientOnDefaultTable {
        @Parameter(names={"-r", "--recent"}, description="List recent traces")
        boolean list = false;
        @Parameter(names={"-ms", "--ms"}, description="Time period of recent traces to list in ms")
        long length = 600000L;
        @Parameter(names={"-d", "--dump"}, description="Dump all traces")
        boolean dump = false;
        @Parameter(description=" <trace id> { <trace id> ... }")
        List<String> traceIds = new ArrayList<String>();

        Opts() {
            super("trace");
        }
    }
}

