/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.conf.AccumuloClusterConfiguration;
import org.apache.accumulo.harness.conf.AccumuloMiniClusterConfiguration;
import org.apache.accumulo.harness.conf.StandaloneAccumuloClusterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccumuloClusterPropertyConfiguration
implements AccumuloClusterConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AccumuloClusterPropertyConfiguration.class);
    public static final String ACCUMULO_IT_PROPERTIES_FILE = "accumulo.it.properties";
    public static final String ACCUMULO_CLUSTER_TYPE_KEY = "accumulo.it.cluster.type";
    public static final String ACCUMULO_MINI_PREFIX = "accumulo.it.cluster.mini.";
    public static final String ACCUMULO_STANDALONE_PREFIX = "accumulo.it.cluster.standalone.";
    public static final String ACCUMULO_CLUSTER_CLIENT_CONF_KEY = "accumulo.it.cluster.clientconf";
    protected AccumuloClusterHarness.ClusterType clusterType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccumuloClusterPropertyConfiguration get() {
        Properties systemProperties = System.getProperties();
        String clusterTypeValue = null;
        String clientConf = null;
        String propertyFile = systemProperties.getProperty(ACCUMULO_IT_PROPERTIES_FILE);
        if (null != propertyFile) {
            File f = new File(propertyFile);
            if (f.exists() && f.isFile() && f.canRead()) {
                Properties fileProperties = new Properties();
                FileReader reader = null;
                try {
                    reader = new FileReader(f);
                }
                catch (FileNotFoundException e) {
                    log.warn("Could not read properties from specified file: {}", (Object)propertyFile, (Object)e);
                }
                if (null != reader) {
                    try {
                        fileProperties.load(reader);
                    }
                    catch (IOException e) {
                        log.warn("Could not load properties from specified file: {}", (Object)propertyFile, (Object)e);
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            log.warn("Could not close reader", (Throwable)e);
                        }
                    }
                    clusterTypeValue = fileProperties.getProperty(ACCUMULO_CLUSTER_TYPE_KEY);
                    clientConf = fileProperties.getProperty(ACCUMULO_CLUSTER_CLIENT_CONF_KEY);
                }
            } else {
                log.debug("Property file ({}) is not a readable file", (Object)propertyFile);
            }
        } else {
            log.debug("No properties file found in {}", (Object)ACCUMULO_IT_PROPERTIES_FILE);
        }
        if (null == clusterTypeValue) {
            clusterTypeValue = systemProperties.getProperty(ACCUMULO_CLUSTER_TYPE_KEY);
        }
        if (null == clientConf) {
            clientConf = systemProperties.getProperty(ACCUMULO_CLUSTER_CLIENT_CONF_KEY);
        }
        AccumuloClusterHarness.ClusterType type = null == clusterTypeValue ? AccumuloClusterHarness.ClusterType.MINI : AccumuloClusterHarness.ClusterType.valueOf(clusterTypeValue);
        log.info("Using {} cluster type from system properties", (Object)type);
        switch (type) {
            case MINI: {
                return new AccumuloMiniClusterConfiguration();
            }
            case STANDALONE: {
                if (null == clientConf) {
                    throw new RuntimeException("Expected client configuration to be provided: accumulo.it.cluster.clientconf");
                }
                File clientConfFile = new File(clientConf);
                if (!clientConfFile.exists() || !clientConfFile.isFile()) {
                    throw new RuntimeException("Client configuration should be a normal file: " + clientConfFile);
                }
                return new StandaloneAccumuloClusterConfiguration(clientConfFile);
            }
        }
        throw new RuntimeException("Clusters other than MiniAccumuloCluster are not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getConfiguration(AccumuloClusterHarness.ClusterType type) {
        File f;
        String prefix;
        Objects.requireNonNull(type);
        switch (type) {
            case MINI: {
                prefix = ACCUMULO_MINI_PREFIX;
                break;
            }
            case STANDALONE: {
                prefix = ACCUMULO_STANDALONE_PREFIX;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ClusterType: " + (Object)((Object)type));
            }
        }
        HashMap<String, String> configuration = new HashMap<String, String>();
        Properties systemProperties = System.getProperties();
        String propertyFile = systemProperties.getProperty(ACCUMULO_IT_PROPERTIES_FILE);
        if (null != propertyFile && (f = new File(propertyFile)).exists() && f.isFile() && f.canRead()) {
            Properties fileProperties = new Properties();
            FileReader reader = null;
            try {
                reader = new FileReader(f);
            }
            catch (FileNotFoundException e) {
                log.warn("Could not read properties from specified file: {}", (Object)propertyFile, (Object)e);
            }
            if (null != reader) {
                try {
                    fileProperties.load(reader);
                    this.loadFromProperties(prefix, fileProperties, configuration);
                }
                catch (IOException e) {
                    log.warn("Could not load properties from specified file: {}", (Object)propertyFile, (Object)e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.warn("Could not close reader", (Throwable)e);
                    }
                }
            }
        }
        this.loadFromProperties(prefix, systemProperties, configuration);
        return configuration;
    }

    protected void loadFromProperties(String desiredPrefix, Properties properties, Map<String, String> configuration) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(key = (String)entry.getKey()).startsWith(desiredPrefix)) continue;
            configuration.put(key, (String)entry.getValue());
        }
    }
}

