/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness.conf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.conf.AccumuloClusterPropertyConfiguration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneAccumuloClusterConfiguration
extends AccumuloClusterPropertyConfiguration {
    private static final Logger log = LoggerFactory.getLogger(StandaloneAccumuloClusterConfiguration.class);
    public static final String ACCUMULO_STANDALONE_ADMIN_PRINCIPAL_KEY = "accumulo.it.cluster.standalone.admin.principal";
    public static final String ACCUMULO_STANDALONE_ADMIN_PRINCIPAL_DEFAULT = "root";
    public static final String ACCUMULO_STANDALONE_PASSWORD_KEY = "accumulo.it.cluster.standalone.admin.password";
    public static final String ACCUMULO_STANDALONE_PASSWORD_DEFAULT = "rootPassword1";
    public static final String ACCUMULO_STANDALONE_ADMIN_KEYTAB_KEY = "accumulo.it.cluster.standalone.admin.keytab";
    public static final String ACCUMULO_STANDALONE_ZOOKEEPERS_KEY = "accumulo.it.cluster.standalone.zookeepers";
    public static final String ACCUMULO_STANDALONE_ZOOKEEPERS_DEFAULT = "localhost";
    public static final String ACCUMULO_STANDALONE_INSTANCE_NAME_KEY = "accumulo.it.cluster.standalone.instance.name";
    public static final String ACCUMULO_STANDALONE_INSTANCE_NAME_DEFAULT = "accumulo";
    public static final String ACCUMULO_STANDALONE_TMP_DIR_KEY = "accumulo.it.cluster.standalone.tmpdir";
    public static final String ACCUMULO_STANDALONE_TMP_DIR_DEFAULT = "/tmp";
    public static final String ACCUMULO_STANDALONE_SERVER_USER = "accumulo.it.cluster.standalone.server.user";
    public static final String ACCUMULO_STANDALONE_SERVER_USER_DEFAULT = "accumulo";
    public static final String ACCUMULO_STANDALONE_USER_KEY = "accumulo.it.cluster.standalone.users.";
    public static final String ACCUMULO_STANDALONE_USER_KEYTABS_KEY = "accumulo.it.cluster.standalone.keytabs.";
    public static final String ACCUMULO_STANDALONE_USER_PASSWORDS_KEY = "accumulo.it.cluster.standalone.passwords.";
    public static final String ACCUMULO_STANDALONE_HOME = "accumulo.it.cluster.standalone.home";
    public static final String ACCUMULO_STANDALONE_CLIENT_CONF = "accumulo.it.cluster.standalone.client.conf";
    public static final String ACCUMULO_STANDALONE_SERVER_CONF = "accumulo.it.cluster.standalone.server.conf";
    public static final String ACCUMULO_STANDALONE_HADOOP_CONF = "accumulo.it.cluster.standalone.hadoop.conf";
    private Map<String, String> conf;
    private String serverUser;
    private File clientConfFile;
    private ClientConfiguration clientConf;
    private List<ClusterUser> clusterUsers;

    public StandaloneAccumuloClusterConfiguration(File clientConfFile) {
        AccumuloClusterHarness.ClusterType type = this.getClusterType();
        if (AccumuloClusterHarness.ClusterType.STANDALONE != type) {
            throw new IllegalStateException("Expected only to see standalone cluster state");
        }
        this.conf = this.getConfiguration(type);
        this.clientConfFile = clientConfFile;
        this.clientConf = ClientConfiguration.fromFile((File)clientConfFile);
        if (!this.clientConf.containsKey(ClientConfiguration.ClientProperty.INSTANCE_NAME.getKey())) {
            this.clientConf.withInstance(this.getInstanceName());
        }
        if (!this.clientConf.containsKey(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST.getKey())) {
            this.clientConf.withZkHosts(this.getZooKeepers());
        }
        this.serverUser = this.conf.get(ACCUMULO_STANDALONE_SERVER_USER);
        if (null == this.serverUser) {
            this.serverUser = "accumulo";
        }
        this.clusterUsers = new ArrayList<ClusterUser>();
        for (Map.Entry<String, String> entry : this.conf.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(ACCUMULO_STANDALONE_USER_KEY)) continue;
            String suffix = key.substring(ACCUMULO_STANDALONE_USER_KEY.length());
            String keytab = this.conf.get(ACCUMULO_STANDALONE_USER_KEYTABS_KEY + suffix);
            if (null != keytab) {
                File keytabFile = new File(keytab);
                Assert.assertTrue((String)("Keytab doesn't exist: " + keytabFile), (keytabFile.exists() && keytabFile.isFile() ? 1 : 0) != 0);
                this.clusterUsers.add(new ClusterUser(entry.getValue(), keytabFile));
                continue;
            }
            String password = this.conf.get(ACCUMULO_STANDALONE_USER_PASSWORDS_KEY + suffix);
            if (null == password) {
                throw new IllegalArgumentException("Missing password or keytab configuration for user with offset " + suffix);
            }
            this.clusterUsers.add(new ClusterUser(entry.getValue(), password));
        }
        log.info("Initialized Accumulo users with Kerberos keytabs: {}", this.clusterUsers);
    }

    @Override
    public String getAdminPrincipal() {
        String principal = this.conf.get(ACCUMULO_STANDALONE_ADMIN_PRINCIPAL_KEY);
        if (null == principal) {
            principal = ACCUMULO_STANDALONE_ADMIN_PRINCIPAL_DEFAULT;
        }
        return principal;
    }

    public String getPassword() {
        String password = this.conf.get(ACCUMULO_STANDALONE_PASSWORD_KEY);
        if (null == password) {
            password = ACCUMULO_STANDALONE_PASSWORD_DEFAULT;
        }
        return password;
    }

    public File getAdminKeytab() {
        String keytabPath = this.conf.get(ACCUMULO_STANDALONE_ADMIN_KEYTAB_KEY);
        if (null == keytabPath) {
            throw new RuntimeException("SASL is enabled, but accumulo.it.cluster.standalone.admin.keytab was not provided");
        }
        File keytab = new File(keytabPath);
        if (!keytab.exists() || !keytab.isFile()) {
            throw new RuntimeException(keytabPath + " should be a regular file");
        }
        return keytab;
    }

    @Override
    public AuthenticationToken getAdminToken() {
        if (this.clientConf.hasSasl()) {
            File keytab = this.getAdminKeytab();
            try {
                UserGroupInformation.loginUserFromKeytab((String)this.getAdminPrincipal(), (String)keytab.getAbsolutePath());
                return new KerberosToken();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create KerberosToken", e);
            }
        }
        return new PasswordToken((CharSequence)this.getPassword());
    }

    public String getZooKeepers() {
        if (this.clientConf.containsKey(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST.getKey())) {
            return this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST);
        }
        String zookeepers = this.conf.get(ACCUMULO_STANDALONE_ZOOKEEPERS_KEY);
        if (null == zookeepers) {
            zookeepers = ACCUMULO_STANDALONE_ZOOKEEPERS_DEFAULT;
        }
        return zookeepers;
    }

    public String getInstanceName() {
        if (this.clientConf.containsKey(ClientConfiguration.ClientProperty.INSTANCE_NAME.getKey())) {
            return this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_NAME);
        }
        String instanceName = this.conf.get(ACCUMULO_STANDALONE_INSTANCE_NAME_KEY);
        if (null == instanceName) {
            instanceName = "accumulo";
        }
        return instanceName;
    }

    public Instance getInstance() {
        return new ZooKeeperInstance(this.clientConf);
    }

    @Override
    public AccumuloClusterHarness.ClusterType getClusterType() {
        return AccumuloClusterHarness.ClusterType.STANDALONE;
    }

    public String getHadoopConfDir() {
        return this.conf.get(ACCUMULO_STANDALONE_HADOOP_CONF);
    }

    public String getAccumuloHome() {
        return this.conf.get(ACCUMULO_STANDALONE_HOME);
    }

    public String getClientAccumuloConfDir() {
        return this.conf.get(ACCUMULO_STANDALONE_CLIENT_CONF);
    }

    public String getServerAccumuloConfDir() {
        return this.conf.get(ACCUMULO_STANDALONE_SERVER_CONF);
    }

    @Override
    public ClientConfiguration getClientConf() {
        return this.clientConf;
    }

    public File getClientConfFile() {
        return this.clientConfFile;
    }

    public Path getTmpDirectory() {
        String tmpDir = this.conf.get(ACCUMULO_STANDALONE_TMP_DIR_KEY);
        if (null == tmpDir) {
            tmpDir = ACCUMULO_STANDALONE_TMP_DIR_DEFAULT;
        }
        return new Path(tmpDir);
    }

    public List<ClusterUser> getUsers() {
        return Collections.unmodifiableList(this.clusterUsers);
    }

    public String getAccumuloServerUser() {
        return this.serverUser;
    }
}

