/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImportVolumeIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BulkImportVolumeIT.class);
    File volDirBase = null;
    Path v1;
    Path v2;

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        File baseDir = cfg.getDir();
        this.volDirBase = new File(baseDir, "volumes");
        File v1f = new File(this.volDirBase, "v1");
        File v2f = new File(this.volDirBase, "v2");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1.toString() + "," + this.v2.toString());
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void testBulkImportFailure() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        TableOperations to = this.getConnector().tableOperations();
        to.create(tableName);
        FileSystem fs = BulkImportVolumeIT.getFileSystem();
        Path rootPath = new Path(cluster.getTemporaryPath(), this.getClass().getName());
        Path bulk = new Path(rootPath, "bulk");
        log.info("bulk: {}", (Object)bulk);
        if (fs.exists(bulk)) {
            fs.delete(bulk, true);
        }
        Assert.assertTrue((boolean)fs.mkdirs(bulk));
        Path err = new Path(rootPath, "err");
        log.info("err: {}", (Object)err);
        if (fs.exists(err)) {
            fs.delete(err, true);
        }
        Assert.assertTrue((boolean)fs.mkdirs(err));
        Path bogus = new Path(bulk, "bogus.rf");
        fs.create(bogus).close();
        log.info("bogus: {}", (Object)bogus);
        Assert.assertTrue((boolean)fs.exists(bogus));
        log.info("Importing {} into {} with failures directory {}", new Object[]{bulk, tableName, err});
        to.importDirectory(tableName, bulk.toString(), err.toString(), false);
        Assert.assertEquals((long)1L, (long)fs.listStatus(err).length);
    }
}

