/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DumpConfigIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setSiteConfig(Collections.singletonMap(Property.TABLE_FILE_BLOCK_SIZE.getKey(), "1234567"));
    }

    @Test
    public void test() throws Exception {
        File target = new File(System.getProperty("user.dir"), "target");
        Assert.assertTrue((target.exists() || target.mkdirs() ? 1 : 0) != 0);
        TemporaryFolder folder = new TemporaryFolder(target);
        folder.create();
        File siteFileBackup = new File(folder.getRoot(), "accumulo-site.xml.bak");
        Assert.assertFalse((boolean)siteFileBackup.exists());
        Assert.assertEquals((long)0L, (long)this.exec(Admin.class, "dumpConfig", "-a", "-d", folder.getRoot().getPath()).waitFor());
        Assert.assertTrue((boolean)siteFileBackup.exists());
        String site = FunctionalTestUtils.readAll(new FileInputStream(siteFileBackup));
        Assert.assertTrue((boolean)site.contains(Property.TABLE_FILE_BLOCK_SIZE.getKey()));
        Assert.assertTrue((boolean)site.contains("1234567"));
        String meta = FunctionalTestUtils.readAll(new FileInputStream(new File(folder.getRoot(), "accumulo.metadata.cfg")));
        Assert.assertTrue((boolean)meta.contains(Property.TABLE_FILE_REPLICATION.getKey()));
        String systemPerm = FunctionalTestUtils.readAll(new FileInputStream(new File(folder.getRoot(), "root_user.cfg")));
        Assert.assertTrue((boolean)systemPerm.contains("grant System.ALTER_USER -s -u root"));
        Assert.assertTrue((boolean)systemPerm.contains("grant Table.READ -t accumulo.metadata -u root"));
        Assert.assertFalse((boolean)systemPerm.contains("grant Table.DROP -t accumulo.metadata -u root"));
    }
}

