/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class FindMaxIT
extends AccumuloClusterHarness {
    private static Mutation nm(byte[] row) {
        Mutation m = new Mutation(new Text(row));
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
        return m;
    }

    private static Mutation nm(String row) {
        Mutation m = new Mutation((CharSequence)row);
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
        return m;
    }

    @Test
    public void test1() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        bw.addMutation(FindMaxIT.nm(new byte[]{0}));
        bw.addMutation(FindMaxIT.nm(new byte[]{0, 0}));
        bw.addMutation(FindMaxIT.nm(new byte[]{0, 1}));
        bw.addMutation(FindMaxIT.nm(new byte[]{0, 1, 0}));
        bw.addMutation(FindMaxIT.nm(new byte[]{1, 0}));
        bw.addMutation(FindMaxIT.nm(new byte[]{97, 98, 99}));
        bw.addMutation(FindMaxIT.nm(new byte[]{-1}));
        bw.addMutation(FindMaxIT.nm(new byte[]{-1, -1, -1, -1, -1, -1}));
        for (int i = 0; i < 1000; i += 5) {
            bw.addMutation(FindMaxIT.nm(String.format("r%05d", i)));
        }
        bw.close();
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        ArrayList<Text> rows = new ArrayList<Text>();
        for (Map.Entry entry : scanner) {
            rows.add(((Key)entry.getKey()).getRow());
        }
        for (int i = rows.size() - 1; i > 0; --i) {
            Text max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, (Text)rows.get(i), false);
            Assert.assertEquals(rows.get(i - 1), (Object)max);
            max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i - 1), true, (Text)rows.get(i), false);
            Assert.assertEquals(rows.get(i - 1), (Object)max);
            max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i - 1), false, (Text)rows.get(i), false);
            Assert.assertNull((Object)max);
            max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, (Text)rows.get(i), true);
            Assert.assertEquals(rows.get(i), (Object)max);
            max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i), true, (Text)rows.get(i), true);
            Assert.assertEquals(rows.get(i), (Object)max);
            max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i - 1), false, (Text)rows.get(i), true);
            Assert.assertEquals(rows.get(i), (Object)max);
        }
        Text max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, null, true);
        Assert.assertEquals(rows.get(rows.size() - 1), (Object)max);
        max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, new Text(new byte[]{0}), false);
        Assert.assertNull((Object)max);
        max = conn.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, new Text(new byte[]{0}), true);
        Assert.assertEquals(rows.get(0), (Object)max);
    }
}

