/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

abstract class MemoryUsageTest {
    MemoryUsageTest() {
    }

    abstract void addEntry(int var1);

    abstract int getEstimatedBytesPerEntry();

    abstract void clear();

    abstract int getNumPasses();

    abstract String getName();

    abstract void init();

    public void run() {
        System.gc();
        long usedMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        for (int count = 0; usedMem > 0x100000L && count < 10; ++count) {
            System.gc();
            usedMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        }
        this.init();
        for (int i = 0; i < this.getNumPasses(); ++i) {
            this.addEntry(i);
        }
        System.gc();
        long memSize = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() - usedMem;
        double actualBytesPerEntry = (double)memSize / (double)this.getNumPasses();
        double expectedBytesPerEntry = this.getEstimatedBytesPerEntry();
        double diff = actualBytesPerEntry - expectedBytesPerEntry;
        double ratio = actualBytesPerEntry / expectedBytesPerEntry * 100.0;
        System.out.printf("%30s | %,10d | %6.2fGB | %6.2f | %6.2f | %6.2f | %6.2f%s%n", this.getName(), this.getNumPasses(), (double)memSize / 1.073741824E9, actualBytesPerEntry, expectedBytesPerEntry, diff, ratio, "%");
        this.clear();
    }
}

