/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;

public class MetaGetsReadersIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.TSERV_SCAN_MAX_OPENFILES, "2");
        cfg.setProperty(Property.TABLE_BLOCKCACHE_ENABLED, "false");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    private static Thread slowScan(final Connector c, final String tableName, final AtomicBoolean stop) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (!stop.get()) {
                        Scanner s = c.createScanner(tableName, Authorizations.EMPTY);
                        IteratorSetting is = new IteratorSetting(50, SlowIterator.class);
                        SlowIterator.setSleepTime(is, 10L);
                        s.addScanIterator(is);
                        Iterator iterator = s.iterator();
                        while (iterator.hasNext() && !stop.get()) {
                            iterator.next();
                        }
                    }
                }
                catch (Exception ex) {
                    ConfigurableMacBase.log.trace("{}", (Object)ex.getMessage(), (Object)ex);
                    stop.set(true);
                }
            }
        };
        return thread;
    }

    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(tableName);
        Random random = new Random();
        BatchWriter bw = c.createBatchWriter(tableName, null);
        for (int i = 0; i < 50000; ++i) {
            byte[] row = new byte[100];
            random.nextBytes(row);
            Mutation m = new Mutation(row);
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
        bw.close();
        c.tableOperations().flush(tableName, null, null, true);
        AtomicBoolean stop = new AtomicBoolean(false);
        Thread t1 = MetaGetsReadersIT.slowScan(c, tableName, stop);
        t1.start();
        Thread t2 = MetaGetsReadersIT.slowScan(c, tableName, stop);
        t2.start();
        UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        long now = System.currentTimeMillis();
        Scanner m = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        Iterators.size((Iterator)m.iterator());
        long delay = System.currentTimeMillis() - now;
        System.out.println("Delay = " + delay);
        Assert.assertTrue((String)"metadata table scan was slow", (delay < 1000L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)stop.get());
        stop.set(true);
        t1.interrupt();
        t2.interrupt();
        t1.join();
        t2.join();
    }
}

