/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MetaRecoveryIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.TSERV_ARCHIVE_WALOGS, "true");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "1048576");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void test() throws Exception {
        String[] tables = this.getUniqueNames(10);
        Connector c = this.getConnector();
        int i = 0;
        for (String table : tables) {
            log.info("Creating table {}", (Object)i);
            c.tableOperations().create(table);
            BatchWriter bw = c.createBatchWriter(table, null);
            for (int j = 0; j < 1000; ++j) {
                Mutation m = new Mutation((CharSequence)("" + j));
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            bw.close();
            log.info("Data written to table {}", (Object)i);
            ++i;
        }
        c.tableOperations().flush("accumulo.metadata", null, null, true);
        c.tableOperations().flush("accumulo.root", null, null, true);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (i = 1; i < tables.length; ++i) {
            splits.add(new Text("" + i));
        }
        c.tableOperations().addSplits("accumulo.metadata", splits);
        log.info("Added {} splits to {}", (Object)splits.size(), (Object)"accumulo.metadata");
        c.instanceOperations().waitForBalance();
        log.info("Restarting");
        this.getCluster().getClusterControl().kill(ServerType.TABLET_SERVER, "localhost");
        this.getCluster().start();
        log.info("Verifying");
        for (String table : tables) {
            BatchScanner scanner = c.createBatchScanner(table, Authorizations.EMPTY, 5);
            scanner.setRanges(Collections.singletonList(new Range()));
            Assert.assertEquals((long)1000L, (long)Iterators.size((Iterator)scanner.iterator()));
            scanner.close();
        }
    }
}

