/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.OrIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class OrIteratorIT
extends AccumuloClusterHarness {
    private static final String EMPTY = "";

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testMultipleRowsInTablet() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"bob", (CharSequence)"2", (CharSequence)EMPTY);
            m.put((CharSequence)"frank", (CharSequence)"3", (CharSequence)EMPTY);
            m.put((CharSequence)"steve", (CharSequence)"1", (CharSequence)EMPTY);
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row2");
            m.put((CharSequence)"bob", (CharSequence)"7", (CharSequence)EMPTY);
            m.put((CharSequence)"eddie", (CharSequence)"4", (CharSequence)EMPTY);
            m.put((CharSequence)"mort", (CharSequence)"6", (CharSequence)EMPTY);
            m.put((CharSequence)"zed", (CharSequence)"5", (CharSequence)EMPTY);
            bw.addMutation(m);
        }
        IteratorSetting is = new IteratorSetting(50, OrIterator.class);
        is.addOption("or.iterator.columns", "mort,frank");
        HashMap<String, String> expectedData = new HashMap<String, String>();
        expectedData.put("frank", "3");
        expectedData.put("mort", "6");
        try (BatchScanner bs = conn.createBatchScanner(tableName, Authorizations.EMPTY, 1);){
            HashSet<Range> ranges = new HashSet<Range>(Arrays.asList(Range.exact((CharSequence)"row1"), Range.exact((CharSequence)"row2")));
            bs.setRanges(ranges);
            bs.addScanIterator(is);
            for (Map.Entry entry : bs) {
                String term = ((Key)entry.getKey()).getColumnFamily().toString();
                String expectedDocId = (String)expectedData.remove(term);
                Assert.assertNotNull((String)("Found unexpected term: " + term), (Object)expectedDocId);
                Assert.assertEquals((Object)expectedDocId, (Object)((Key)entry.getKey()).getColumnQualifier().toString());
            }
            Assert.assertTrue((String)("Expected no leftover entries but saw " + expectedData), (boolean)expectedData.isEmpty());
        }
    }

    @Test
    public void testMultipleTablets() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"bob", (CharSequence)"2", (CharSequence)EMPTY);
            m.put((CharSequence)"frank", (CharSequence)"3", (CharSequence)EMPTY);
            m.put((CharSequence)"steve", (CharSequence)"1", (CharSequence)EMPTY);
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row2");
            m.put((CharSequence)"bob", (CharSequence)"7", (CharSequence)EMPTY);
            m.put((CharSequence)"eddie", (CharSequence)"4", (CharSequence)EMPTY);
            m.put((CharSequence)"mort", (CharSequence)"6", (CharSequence)EMPTY);
            m.put((CharSequence)"zed", (CharSequence)"5", (CharSequence)EMPTY);
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row3");
            m.put((CharSequence)"carl", (CharSequence)"9", (CharSequence)EMPTY);
            m.put((CharSequence)"george", (CharSequence)"8", (CharSequence)EMPTY);
            m.put((CharSequence)"nick", (CharSequence)"3", (CharSequence)EMPTY);
            m.put((CharSequence)"zed", (CharSequence)"1", (CharSequence)EMPTY);
            bw.addMutation(m);
        }
        conn.tableOperations().addSplits(tableName, new TreeSet<Text>(Arrays.asList(new Text("row2"), new Text("row3"))));
        IteratorSetting is = new IteratorSetting(50, OrIterator.class);
        is.addOption("or.iterator.columns", "mort,frank,nick");
        HashMap<String, String> expectedData = new HashMap<String, String>();
        expectedData.put("frank", "3");
        expectedData.put("mort", "6");
        expectedData.put("nick", "3");
        try (BatchScanner bs = conn.createBatchScanner(tableName, Authorizations.EMPTY, 1);){
            bs.setRanges(Collections.singleton(new Range()));
            bs.addScanIterator(is);
            for (Map.Entry entry : bs) {
                String term = ((Key)entry.getKey()).getColumnFamily().toString();
                String expectedDocId = (String)expectedData.remove(term);
                Assert.assertNotNull((String)("Found unexpected term: " + term), (Object)expectedDocId);
                Assert.assertEquals((Object)expectedDocId, (Object)((Key)entry.getKey()).getColumnQualifier().toString());
            }
            Assert.assertTrue((String)("Expected no leftover entries but saw " + expectedData), (boolean)expectedData.isEmpty());
        }
    }

    @Test
    public void testSingleLargeRow() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        conn.tableOperations().setProperty(tableName, Property.TABLE_SCAN_MAXMEM.getKey(), "1");
        try (BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"bob", (CharSequence)"02", (CharSequence)EMPTY);
            m.put((CharSequence)"carl", (CharSequence)"07", (CharSequence)EMPTY);
            m.put((CharSequence)"eddie", (CharSequence)"04", (CharSequence)EMPTY);
            m.put((CharSequence)"frank", (CharSequence)"03", (CharSequence)EMPTY);
            m.put((CharSequence)"greg", (CharSequence)"15", (CharSequence)EMPTY);
            m.put((CharSequence)"mort", (CharSequence)"06", (CharSequence)EMPTY);
            m.put((CharSequence)"nick", (CharSequence)"12", (CharSequence)EMPTY);
            m.put((CharSequence)"richard", (CharSequence)"18", (CharSequence)EMPTY);
            m.put((CharSequence)"steve", (CharSequence)"01", (CharSequence)EMPTY);
            m.put((CharSequence)"ted", (CharSequence)"11", (CharSequence)EMPTY);
            m.put((CharSequence)"zed", (CharSequence)"05", (CharSequence)EMPTY);
            bw.addMutation(m);
        }
        IteratorSetting is = new IteratorSetting(50, OrIterator.class);
        is.addOption("or.iterator.columns", "richard,carl,frank,nick,eddie,zed");
        HashMap<String, String> expectedData = new HashMap<String, String>();
        expectedData.put("frank", "03");
        expectedData.put("eddie", "04");
        expectedData.put("zed", "05");
        expectedData.put("carl", "07");
        expectedData.put("nick", "12");
        expectedData.put("richard", "18");
        try (BatchScanner bs = conn.createBatchScanner(tableName, Authorizations.EMPTY, 1);){
            bs.setRanges(Collections.singleton(new Range()));
            bs.addScanIterator(is);
            for (Map.Entry entry : bs) {
                String term = ((Key)entry.getKey()).getColumnFamily().toString();
                String expectedDocId = (String)expectedData.remove(term);
                Assert.assertNotNull((String)("Found unexpected term: " + term + " or the docId was unexpectedly null"), (Object)expectedDocId);
                Assert.assertEquals((Object)expectedDocId, (Object)((Key)entry.getKey()).getColumnQualifier().toString());
            }
            Assert.assertTrue((String)("Expected no leftover entries but saw " + expectedData), (boolean)expectedData.isEmpty());
        }
    }

    @Test
    public void testNoMatchesForTable() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"bob", (CharSequence)"02", (CharSequence)EMPTY);
            m.put((CharSequence)"carl", (CharSequence)"07", (CharSequence)EMPTY);
            m.put((CharSequence)"eddie", (CharSequence)"04", (CharSequence)EMPTY);
            m.put((CharSequence)"frank", (CharSequence)"03", (CharSequence)EMPTY);
            m.put((CharSequence)"greg", (CharSequence)"15", (CharSequence)EMPTY);
            m.put((CharSequence)"mort", (CharSequence)"06", (CharSequence)EMPTY);
            m.put((CharSequence)"nick", (CharSequence)"12", (CharSequence)EMPTY);
            m.put((CharSequence)"richard", (CharSequence)"18", (CharSequence)EMPTY);
            m.put((CharSequence)"steve", (CharSequence)"01", (CharSequence)EMPTY);
            m.put((CharSequence)"ted", (CharSequence)"11", (CharSequence)EMPTY);
            m.put((CharSequence)"zed", (CharSequence)"05", (CharSequence)EMPTY);
            bw.addMutation(m);
        }
        IteratorSetting is = new IteratorSetting(50, OrIterator.class);
        is.addOption("or.iterator.columns", "theresa,sally");
        Map expectedData = Collections.emptyMap();
        try (BatchScanner bs = conn.createBatchScanner(tableName, Authorizations.EMPTY, 1);){
            bs.setRanges(Collections.singleton(new Range()));
            bs.addScanIterator(is);
            for (Map.Entry entry : bs) {
                String term = ((Key)entry.getKey()).getColumnFamily().toString();
                String expectedDocId = (String)expectedData.remove(term);
                Assert.assertNotNull((String)("Found unexpected term: " + term + " or the docId was unexpectedly null"), (Object)expectedDocId);
                Assert.assertEquals((Object)expectedDocId, (Object)((Key)entry.getKey()).getColumnQualifier().toString());
            }
            Assert.assertTrue((String)("Expected no leftover entries but saw " + expectedData), (boolean)expectedData.isEmpty());
        }
    }

    @Test
    public void testNoMatchesInSingleTablet() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"bob", (CharSequence)"02", (CharSequence)EMPTY);
            m.put((CharSequence)"carl", (CharSequence)"07", (CharSequence)EMPTY);
            m.put((CharSequence)"eddie", (CharSequence)"04", (CharSequence)EMPTY);
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row2");
            m.put((CharSequence)"frank", (CharSequence)"03", (CharSequence)EMPTY);
            m.put((CharSequence)"greg", (CharSequence)"15", (CharSequence)EMPTY);
            m.put((CharSequence)"mort", (CharSequence)"06", (CharSequence)EMPTY);
            m.put((CharSequence)"nick", (CharSequence)"12", (CharSequence)EMPTY);
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row3");
            m.put((CharSequence)"richard", (CharSequence)"18", (CharSequence)EMPTY);
            m.put((CharSequence)"steve", (CharSequence)"01", (CharSequence)EMPTY);
            m.put((CharSequence)"ted", (CharSequence)"11", (CharSequence)EMPTY);
            m.put((CharSequence)"zed", (CharSequence)"05", (CharSequence)EMPTY);
            bw.addMutation(m);
        }
        IteratorSetting is = new IteratorSetting(50, OrIterator.class);
        is.addOption("or.iterator.columns", "bob,eddie,steve,zed");
        HashMap<String, String> expectedData = new HashMap<String, String>();
        expectedData.put("bob", "02");
        expectedData.put("eddie", "04");
        expectedData.put("zed", "05");
        expectedData.put("steve", "01");
        conn.tableOperations().addSplits(tableName, new TreeSet<Text>(Arrays.asList(new Text("row2"), new Text("row3"))));
        try (BatchScanner bs = conn.createBatchScanner(tableName, Authorizations.EMPTY, 1);){
            bs.setRanges(Collections.singleton(new Range()));
            bs.addScanIterator(is);
            for (Map.Entry entry : bs) {
                String term = ((Key)entry.getKey()).getColumnFamily().toString();
                String expectedDocId = (String)expectedData.remove(term);
                Assert.assertNotNull((String)("Found unexpected term: " + term + " or the docId was unexpectedly null"), (Object)expectedDocId);
                Assert.assertEquals((Object)expectedDocId, (Object)((Key)entry.getKey()).getColumnQualifier().toString());
            }
            Assert.assertTrue((String)("Expected no leftover entries but saw " + expectedData), (boolean)expectedData.isEmpty());
        }
    }

    @Test
    public void testResultOrder() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"bob", (CharSequence)"2", (CharSequence)EMPTY);
            m.put((CharSequence)"frank", (CharSequence)"3", (CharSequence)EMPTY);
            m.put((CharSequence)"steve", (CharSequence)"1", (CharSequence)EMPTY);
            bw.addMutation(m);
        }
        IteratorSetting is = new IteratorSetting(50, OrIterator.class);
        is.addOption("or.iterator.columns", "bob,steve");
        try (Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);){
            s.addScanIterator(is);
            Iterator iter = s.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Key k = (Key)((Map.Entry)iter.next()).getKey();
            Assert.assertEquals((String)("Actual key was " + k), (long)0L, (long)k.compareTo(new Key((CharSequence)"row1", (CharSequence)"steve", (CharSequence)"1"), PartialKey.ROW_COLFAM_COLQUAL));
            Assert.assertTrue((boolean)iter.hasNext());
            k = (Key)((Map.Entry)iter.next()).getKey();
            Assert.assertEquals((String)("Actual key was " + k), (long)0L, (long)k.compareTo(new Key((CharSequence)"row1", (CharSequence)"bob", (CharSequence)"2"), PartialKey.ROW_COLFAM_COLQUAL));
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }
}

