/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class SplitRecoveryIT
extends AccumuloClusterHarness {
    private Mutation m(String row) {
        Mutation result = new Mutation((CharSequence)row);
        result.put((CharSequence)"cf", (CharSequence)"cq", new Value("value".getBytes()));
        return result;
    }

    boolean isOffline(String tablename, Connector connector) throws TableNotFoundException {
        String tableId = (String)connector.tableOperations().tableIdMap().get(tablename);
        Scanner scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.setRange(new Range(new Text(tableId + ";"), new Text(tableId + "<")));
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        return Iterators.size((Iterator)scanner.iterator()) == 0;
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        for (int tn = 0; tn < 2; ++tn) {
            Scanner scanner;
            Connector connector = this.getConnector();
            connector.tableOperations().create(tableName);
            BatchWriter bw = connector.createBatchWriter(tableName, new BatchWriterConfig());
            bw.addMutation(this.m("a"));
            bw.addMutation(this.m("b"));
            bw.addMutation(this.m("c"));
            bw.close();
            connector.tableOperations().offline(tableName);
            while (!this.isOffline(tableName, connector)) {
                UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            connector.securityOperations().grantTablePermission(SplitRecoveryIT.getAdminPrincipal(), "accumulo.metadata", TablePermission.WRITE);
            String tableId = (String)connector.tableOperations().tableIdMap().get(tableName);
            KeyExtent extent = new KeyExtent(tableId, null, new Text("b"));
            Mutation m = extent.getPrevRowUpdateMutation();
            MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value(Double.toString(0.5).getBytes()));
            MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow(null));
            bw = connector.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
            bw.addMutation(m);
            if (tn == 1) {
                bw.flush();
                scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
                scanner.setRange(extent.toMetadataRange());
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                KeyExtent extent2 = new KeyExtent(tableId, new Text("b"), null);
                m = extent2.getPrevRowUpdateMutation();
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value("/t2".getBytes()));
                MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value("M0".getBytes()));
                for (Map.Entry entry : scanner) {
                    m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, ((Key)entry.getKey()).getColumnQualifier(), (Value)entry.getValue());
                }
                bw.addMutation(m);
            }
            bw.close();
            connector.tableOperations().online(tableName);
            scanner = connector.createScanner(tableName, Authorizations.EMPTY);
            int i = 0;
            String[] expected = new String[]{"a", "b", "c"};
            for (Map.Entry entry : scanner) {
                Assert.assertEquals((Object)expected[i], (Object)((Key)entry.getKey()).getRow().toString());
                ++i;
            }
            Assert.assertEquals((long)3L, (long)i);
            connector.tableOperations().delete(tableName);
        }
    }
}

