/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.accumulo.test.continuous.ContinuousOpts;
import org.apache.accumulo.test.continuous.ContinuousUtil;
import org.apache.accumulo.test.continuous.ContinuousWalk;
import org.apache.hadoop.io.Text;

public class ContinuousQuery {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        ClientOnDefaultTable clientOpts = new ClientOnDefaultTable("ci");
        clientOpts.parseArgs(ContinuousQuery.class.getName(), args, new Object[]{scanOpts, opts});
        Connector conn = clientOpts.getConnector();
        Scanner scanner = ContinuousUtil.createScanner(conn, clientOpts.getTableName(), clientOpts.auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        Random r = new Random();
        while (true) {
            byte[] row = ContinuousIngest.genRow(opts.min, opts.max, r);
            int count = 0;
            long t1 = System.currentTimeMillis();
            scanner.setRange(new Range(new Text(row)));
            for (Map.Entry entry : scanner) {
                ContinuousWalk.validate((Key)entry.getKey(), (Value)entry.getValue());
                ++count;
            }
            long t2 = System.currentTimeMillis();
            System.out.printf("SRQ %d %s %d %d%n", t1, new String(row, StandardCharsets.UTF_8), t2 - t1, count);
            if (opts.sleepTime <= 0L) continue;
            Thread.sleep(opts.sleepTime);
        }
    }

    public static class Opts
    extends ContinuousOpts {
        @Parameter(names={"--sleep"}, description="the time to wait between queries", converter=ClientOpts.TimeConverter.class)
        long sleepTime = 100L;
    }
}

