/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.test.continuous.HistData;

public class Histogram<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long sum = 0L;
    protected HashMap<T, HistData<T>> counts = new HashMap();

    public void addPoint(T x) {
        this.addPoint(x, 1L);
    }

    public void addPoint(T x, long y) {
        HistData<T> hd = this.counts.get(x);
        if (hd == null) {
            hd = new HistData<T>(x);
            this.counts.put(x, hd);
        }
        hd.count += y;
        this.sum += y;
    }

    public long getCount(T x) {
        HistData<T> hd = this.counts.get(x);
        if (hd == null) {
            return 0L;
        }
        return hd.count;
    }

    public double getPercentage(T x) {
        if (this.getSum() == 0L) {
            return 0.0;
        }
        return (double)this.getCount(x) / (double)this.getSum() * 100.0;
    }

    public long getSum() {
        return this.sum;
    }

    public List<T> getKeysInCountSortedOrder() {
        ArrayList<HistData<T>> sortedCounts = new ArrayList<HistData<T>>(this.counts.values());
        Collections.sort(sortedCounts, new Comparator<HistData<T>>(){

            @Override
            public int compare(HistData<T> o1, HistData<T> o2) {
                if (o1.count < o2.count) {
                    return -1;
                }
                if (o1.count > o2.count) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList sortedKeys = new ArrayList();
        for (HistData<T> hd : sortedCounts) {
            sortedKeys.add(hd.bin);
        }
        return sortedKeys;
    }

    public void print(StringBuilder out) {
        TreeSet<HistData<T>> sortedCounts = new TreeSet<HistData<T>>(this.counts.values());
        int maxValueLen = 0;
        for (HistData<T> hd : sortedCounts) {
            if (("" + hd.bin).length() <= maxValueLen) continue;
            maxValueLen = ("" + hd.bin).length();
        }
        double psum = 0.0;
        for (HistData<T> hd : sortedCounts) {
            out.append(String.format(" %" + (maxValueLen + 1) + "s %,16d %6.2f%s %6.2f%s%n", hd.bin + "", hd.count, this.getPercentage(hd.bin), "%", psum += this.getPercentage(hd.bin), "%"));
        }
        out.append(String.format("%n %" + (maxValueLen + 1) + "s %,16d %n", "TOTAL", this.sum));
    }

    public void save(String file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream((OutputStream)bos, false, StandardCharsets.UTF_8.name());
        TreeSet<HistData<T>> sortedCounts = new TreeSet<HistData<T>>(this.counts.values());
        for (HistData<T> hd : sortedCounts) {
            ps.println(" " + hd.bin + " " + hd.count);
        }
        ps.close();
    }

    public Set<T> getKeys() {
        return this.counts.keySet();
    }

    public void clear() {
        this.counts.clear();
        this.sum = 0L;
    }
}

