/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.BinaryIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinaryStressIT
extends AccumuloClusterHarness {
    private String majcDelay;
    private String maxMem;

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_MAXMEM, "50K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "0");
    }

    @Before
    public void alterConfig() throws Exception {
        if (AccumuloClusterHarness.ClusterType.MINI == BinaryStressIT.getClusterType()) {
            return;
        }
        InstanceOperations iops = this.getConnector().instanceOperations();
        Map conf = iops.getSystemConfiguration();
        this.majcDelay = (String)conf.get(Property.TSERV_MAJC_DELAY.getKey());
        this.maxMem = (String)conf.get(Property.TSERV_MAXMEM.getKey());
        iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "0");
        iops.setProperty(Property.TSERV_MAXMEM.getKey(), "50K");
        BinaryStressIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
        BinaryStressIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
    }

    @After
    public void resetConfig() throws Exception {
        if (null != this.majcDelay) {
            InstanceOperations iops = this.getConnector().instanceOperations();
            iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
            iops.setProperty(Property.TSERV_MAXMEM.getKey(), this.maxMem);
            BinaryStressIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            BinaryStressIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @Test
    public void binaryStressTest() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
        BinaryIT.runTest(c, tableName);
        String id = (String)c.tableOperations().tableIdMap().get(tableName);
        HashSet<Text> tablets = new HashSet<Text>();
        Scanner s = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(Range.prefix((CharSequence)id));
        for (Map.Entry entry : s) {
            tablets.add(((Key)entry.getKey()).getRow());
        }
        Assert.assertTrue((String)("Expected at least 8 tablets, saw " + tablets.size()), (tablets.size() > 7 ? 1 : 0) != 0);
    }
}

