/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class BulkFileIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration conf) {
        cfg.setMemory(ServerType.TABLET_SERVER, 512L, MemoryUnit.MEGABYTE);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void testBulkFile() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (String split : "0333 0666 0999 1333 1666".split(" ")) {
            splits.add(new Text(split));
        }
        c.tableOperations().addSplits(tableName, splits);
        Configuration conf = new Configuration();
        AccumuloConfiguration aconf = new ServerConfigurationFactory(c.getInstance()).getConfiguration();
        FileSystem fs = BulkFileIT.getCluster().getFileSystem();
        String rootPath = cluster.getTemporaryPath().toString();
        String dir = rootPath + "/bulk_test_diff_files_89723987592_" + this.getUniqueNames(1)[0];
        fs.delete(new Path(dir), true);
        FileSKVWriter writer1 = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(dir + "/f1." + "rf", fs, conf).withTableConfiguration(aconf)).build();
        writer1.startDefaultLocalityGroup();
        this.writeData(writer1, 0, 333);
        writer1.close();
        FileSKVWriter writer2 = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(dir + "/f2." + "rf", fs, conf).withTableConfiguration(aconf)).build();
        writer2.startDefaultLocalityGroup();
        this.writeData(writer2, 334, 999);
        writer2.close();
        FileSKVWriter writer3 = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(dir + "/f3." + "rf", fs, conf).withTableConfiguration(aconf)).build();
        writer3.startDefaultLocalityGroup();
        this.writeData(writer3, 1000, 1999);
        writer3.close();
        FunctionalTestUtils.bulkImport(c, fs, tableName, dir);
        FunctionalTestUtils.checkRFiles(c, tableName, 6, 6, 1, 1);
        this.verifyData(tableName, 0, 1999);
    }

    private void verifyData(String table, int s, int e) throws Exception {
        Scanner scanner = this.getConnector().createScanner(table, Authorizations.EMPTY);
        Iterator iter = scanner.iterator();
        for (int i = s; i <= e; ++i) {
            if (!iter.hasNext()) {
                throw new Exception("row " + i + " not found");
            }
            Map.Entry entry = (Map.Entry)iter.next();
            String row = String.format("%04d", i);
            if (!((Key)entry.getKey()).getRow().equals((Object)new Text(row))) {
                throw new Exception("unexpected row " + entry.getKey() + " " + i);
            }
            if (Integer.parseInt(((Value)entry.getValue()).toString()) == i) continue;
            throw new Exception("unexpected value " + entry + " " + i);
        }
        if (iter.hasNext()) {
            throw new Exception("found more than expected " + iter.next());
        }
    }

    private void writeData(FileSKVWriter w, int s, int e) throws Exception {
        for (int i = s; i <= e; ++i) {
            w.append(new Key(new Text(String.format("%04d", i))), new Value(Integer.toString(i).getBytes(StandardCharsets.UTF_8)));
        }
    }
}

