/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CreateAndUseIT
extends AccumuloClusterHarness {
    private static SortedSet<Text> splits;

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @BeforeClass
    public static void createData() throws Exception {
        splits = new TreeSet<Text>();
        for (int i = 1; i < 256; ++i) {
            splits.add(new Text(String.format("%08x", i << 8)));
        }
    }

    @Test
    public void verifyDataIsPresent() throws Exception {
        Text cf = new Text("cf1");
        Text cq = new Text("cq1");
        String tableName = this.getUniqueNames(1)[0];
        this.getConnector().tableOperations().create(tableName);
        this.getConnector().tableOperations().addSplits(tableName, splits);
        BatchWriter bw = this.getConnector().createBatchWriter(tableName, new BatchWriterConfig());
        for (int i = 1; i < 257; ++i) {
            Mutation m = new Mutation(new Text(String.format("%08x", (i << 8) - 16)));
            m.put(cf, cq, new Value(Integer.toString(i).getBytes(StandardCharsets.UTF_8)));
            bw.addMutation(m);
        }
        bw.close();
        Scanner scanner1 = this.getConnector().createScanner(tableName, Authorizations.EMPTY);
        int ei = 1;
        for (Map.Entry entry : scanner1) {
            Assert.assertEquals((Object)String.format("%08x", (ei << 8) - 16), (Object)((Key)entry.getKey()).getRow().toString());
            Assert.assertEquals((Object)Integer.toString(ei), (Object)((Value)entry.getValue()).toString());
            ++ei;
        }
        Assert.assertEquals((String)"Did not see expected number of rows", (long)257L, (long)ei);
    }

    @Test
    public void createTableAndScan() throws Exception {
        String table2 = this.getUniqueNames(1)[0];
        this.getConnector().tableOperations().create(table2);
        this.getConnector().tableOperations().addSplits(table2, splits);
        Scanner scanner2 = this.getConnector().createScanner(table2, Authorizations.EMPTY);
        int count = 0;
        for (Map.Entry entry : scanner2) {
            if (entry == null) continue;
            ++count;
        }
        if (count != 0) {
            throw new Exception("Did not see expected number of entries, count = " + count);
        }
    }

    @Test
    public void createTableAndBatchScan() throws Exception {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 1; i < 257; ++i) {
            ranges.add(new Range(new Text(String.format("%08x", (i << 8) - 16))));
        }
        String table3 = this.getUniqueNames(1)[0];
        this.getConnector().tableOperations().create(table3);
        this.getConnector().tableOperations().addSplits(table3, splits);
        BatchScanner bs = this.getConnector().createBatchScanner(table3, Authorizations.EMPTY, 3);
        bs.setRanges(ranges);
        Iterator iter = bs.iterator();
        int count = Iterators.size((Iterator)iter);
        bs.close();
        Assert.assertEquals((String)"Did not expect to find any entries", (long)0L, (long)count);
    }
}

