/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.TestRandomDeletes;
import org.apache.accumulo.test.VerifyIngest;
import org.junit.Assert;
import org.junit.Test;

public class DeleteIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        AuthenticationToken token = DeleteIT.getAdminToken();
        if (token instanceof KerberosToken) {
            DeleteIT.deleteTest(c, DeleteIT.getCluster(), DeleteIT.getAdminPrincipal(), null, tableName, this.getAdminUser().getKeytab().getAbsolutePath());
        } else if (token instanceof PasswordToken) {
            PasswordToken passwdToken = (PasswordToken)token;
            DeleteIT.deleteTest(c, DeleteIT.getCluster(), DeleteIT.getAdminPrincipal(), new String(passwdToken.getPassword(), StandardCharsets.UTF_8), tableName, null);
        }
    }

    public static void deleteTest(Connector c, AccumuloCluster cluster, String user, String password, String tableName, String keytab) throws Exception {
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        TestIngest.Opts opts = new TestIngest.Opts();
        vopts.setTableName(tableName);
        opts.setTableName(tableName);
        opts.rows = 1000;
        vopts.rows = 1000;
        opts.cols = 1;
        vopts.cols = 1;
        vopts.random = opts.random = Integer.valueOf(56);
        Assert.assertTrue((String)"Expected one of password or keytab", (null != password || null != keytab ? 1 : 0) != 0);
        if (null != password) {
            Assert.assertNull((String)"Given password, expected null keytab", (Object)keytab);
            ClientOpts.Password passwd = new ClientOpts.Password(password);
            opts.setPassword(passwd);
            opts.setPrincipal(user);
            vopts.setPassword(passwd);
            vopts.setPrincipal(user);
        }
        if (null != keytab) {
            Assert.assertNull((String)"Given keytab, expect null password", (Object)password);
            ClientConfiguration clientConfig = cluster.getClientConfig();
            opts.updateKerberosCredentials(clientConfig);
            vopts.updateKerberosCredentials(clientConfig);
        }
        BatchWriterOpts BWOPTS = new BatchWriterOpts();
        TestIngest.ingest(c, opts, BWOPTS);
        String[] args = null;
        Assert.assertTrue((String)"Expected one of password or keytab", (null != password || null != keytab ? 1 : 0) != 0);
        if (null != password) {
            Assert.assertNull((String)"Given password, expected null keytab", (Object)keytab);
            args = new String[]{"-u", user, "-p", password, "-i", cluster.getInstanceName(), "-z", cluster.getZooKeepers(), "--table", tableName};
        }
        if (null != keytab) {
            Assert.assertNull((String)"Given keytab, expect null password", (Object)password);
            args = new String[]{"-u", user, "-i", cluster.getInstanceName(), "-z", cluster.getZooKeepers(), "--table", tableName, "--keytab", keytab};
        }
        Assert.assertEquals((long)0L, (long)cluster.getClusterControl().exec(TestRandomDeletes.class, args));
        TestIngest.ingest(c, opts, BWOPTS);
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
    }
}

