/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.PerformanceTests;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.mrit.IntegrationTestMapReduce;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class, PerformanceTests.class})
public class DurabilityIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(DurabilityIT.class);
    static final long N = 100000L;

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @BeforeClass
    public static void checkMR() {
        Assume.assumeFalse((boolean)IntegrationTestMapReduce.isMapReduce());
    }

    private String[] init() throws Exception {
        String[] tableNames = this.getUniqueNames(4);
        Connector c = this.getConnector();
        TableOperations tableOps = c.tableOperations();
        this.createTable(tableNames[0]);
        this.createTable(tableNames[1]);
        this.createTable(tableNames[2]);
        this.createTable(tableNames[3]);
        tableOps.setProperty(tableNames[1], Property.TABLE_DURABILITY.getKey(), "flush");
        tableOps.setProperty(tableNames[2], Property.TABLE_DURABILITY.getKey(), "log");
        tableOps.setProperty(tableNames[3], Property.TABLE_DURABILITY.getKey(), "none");
        return tableNames;
    }

    private void cleanup(String[] tableNames) throws Exception {
        Connector c = this.getConnector();
        for (String tableName : tableNames) {
            c.tableOperations().delete(tableName);
        }
    }

    private void createTable(String tableName) throws Exception {
        TableOperations tableOps = this.getConnector().tableOperations();
        tableOps.create(tableName);
    }

    @Test
    public void testWriteSpeed() throws Exception {
        TableOperations tableOps = this.getConnector().tableOperations();
        String[] tableNames = this.init();
        long t0 = this.writeSome(tableNames[0], 100000L);
        tableOps.delete(tableNames[0]);
        long t1 = this.writeSome(tableNames[1], 100000L);
        tableOps.delete(tableNames[1]);
        long t2 = this.writeSome(tableNames[2], 100000L);
        tableOps.delete(tableNames[2]);
        long t3 = this.writeSome(tableNames[3], 100000L);
        tableOps.delete(tableNames[3]);
        System.out.println(String.format("sync %d flush %d log %d none %d", t0, t1, t2, t3));
        Assert.assertTrue((String)"flush should be faster than sync", (t0 > t1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"log should be faster than flush", (t1 > t2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"no durability should be faster than log", (t2 > t3 ? 1 : 0) != 0);
    }

    @Test
    public void testSync() throws Exception {
        String[] tableNames = this.init();
        this.writeSome(tableNames[0], 100000L);
        this.restartTServer();
        Assert.assertEquals((long)100000L, (long)this.readSome(tableNames[0]));
        this.cleanup(tableNames);
    }

    @Test
    public void testFlush() throws Exception {
        String[] tableNames = this.init();
        this.writeSome(tableNames[1], 100000L);
        this.restartTServer();
        Assert.assertEquals((long)100000L, (long)this.readSome(tableNames[1]));
        this.cleanup(tableNames);
    }

    @Test
    public void testLog() throws Exception {
        String[] tableNames = this.init();
        this.writeSome(tableNames[2], 100000L);
        this.restartTServer();
        long numResults = this.readSome(tableNames[2]);
        Assert.assertTrue((String)("Expected 100000 >= " + numResults), (100000L >= numResults ? 1 : 0) != 0);
        this.cleanup(tableNames);
    }

    @Test
    public void testNone() throws Exception {
        String[] tableNames = this.init();
        this.writeSome(tableNames[3], 100000L);
        this.restartTServer();
        long numResults = this.readSome(tableNames[3]);
        Assert.assertTrue((String)("Expected 100000 >= " + numResults), (100000L >= numResults ? 1 : 0) != 0);
        this.cleanup(tableNames);
    }

    @Test
    public void testIncreaseDurability() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "none");
        this.writeSome(tableName, 100000L);
        this.restartTServer();
        long numResults = this.readSome(tableName);
        Assert.assertTrue((String)("Expected 100000 >= " + numResults), (100000L >= numResults ? 1 : 0) != 0);
        c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "sync");
        this.writeSome(tableName, 100000L);
        this.restartTServer();
        Assert.assertTrue((100000L == this.readSome(tableName) ? 1 : 0) != 0);
    }

    private static Map<String, String> map(Iterable<Map.Entry<String, String>> entries) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Test
    public void testMetaDurability() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.instanceOperations().setProperty(Property.TABLE_DURABILITY.getKey(), "none");
        Map<String, String> props = DurabilityIT.map(c.tableOperations().getProperties("accumulo.metadata"));
        Assert.assertEquals((Object)"sync", (Object)props.get(Property.TABLE_DURABILITY.getKey()));
        c.tableOperations().create(tableName);
        props = DurabilityIT.map(c.tableOperations().getProperties(tableName));
        Assert.assertEquals((Object)"none", (Object)props.get(Property.TABLE_DURABILITY.getKey()));
        this.restartTServer();
        Assert.assertTrue((boolean)c.tableOperations().exists(tableName));
    }

    private long readSome(String table) throws Exception {
        return Iterators.size((Iterator)this.getConnector().createScanner(table, Authorizations.EMPTY).iterator());
    }

    private void restartTServer() throws Exception {
        for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
            this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
        }
        this.cluster.start();
    }

    private long writeSome(String table, long count) throws Exception {
        int iterations = 5;
        long[] attempts = new long[iterations];
        for (int attempt = 0; attempt < iterations; ++attempt) {
            long now = System.currentTimeMillis();
            Connector c = this.getConnector();
            BatchWriter bw = c.createBatchWriter(table, null);
            int i = 1;
            while ((long)i < count + 1L) {
                Mutation m = new Mutation((CharSequence)("" + i));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                bw.addMutation(m);
                if ((long)i % Math.max(1L, count / 100L) == 0L) {
                    bw.flush();
                }
                ++i;
            }
            bw.close();
            attempts[attempt] = System.currentTimeMillis() - now;
        }
        Arrays.sort(attempts);
        log.info("Attempt durations: {}", (Object)Arrays.toString(attempts));
        return attempts[2];
    }
}

