/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.cluster.standalone.StandaloneAccumuloCluster;
import org.apache.accumulo.cluster.standalone.StandaloneClusterControl;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.AgeOffFilter;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.examples.simple.client.Flush;
import org.apache.accumulo.examples.simple.client.RandomBatchScanner;
import org.apache.accumulo.examples.simple.client.RandomBatchWriter;
import org.apache.accumulo.examples.simple.client.ReadWriteExample;
import org.apache.accumulo.examples.simple.client.RowOperations;
import org.apache.accumulo.examples.simple.client.SequentialBatchWriter;
import org.apache.accumulo.examples.simple.client.TraceDumpExample;
import org.apache.accumulo.examples.simple.client.TracingExample;
import org.apache.accumulo.examples.simple.combiner.StatsCombiner;
import org.apache.accumulo.examples.simple.constraints.MaxMutationSize;
import org.apache.accumulo.examples.simple.dirlist.Ingest;
import org.apache.accumulo.examples.simple.dirlist.QueryUtil;
import org.apache.accumulo.examples.simple.helloworld.InsertWithBatchWriter;
import org.apache.accumulo.examples.simple.helloworld.ReadData;
import org.apache.accumulo.examples.simple.isolation.InterferenceTest;
import org.apache.accumulo.examples.simple.mapreduce.RegexExample;
import org.apache.accumulo.examples.simple.mapreduce.RowHash;
import org.apache.accumulo.examples.simple.mapreduce.TableToFile;
import org.apache.accumulo.examples.simple.mapreduce.TeraSortIngest;
import org.apache.accumulo.examples.simple.mapreduce.WordCount;
import org.apache.accumulo.examples.simple.mapreduce.bulk.BulkIngestExample;
import org.apache.accumulo.examples.simple.mapreduce.bulk.GenerateTestData;
import org.apache.accumulo.examples.simple.mapreduce.bulk.SetupTable;
import org.apache.accumulo.examples.simple.mapreduce.bulk.VerifyIngest;
import org.apache.accumulo.examples.simple.shard.ContinuousQuery;
import org.apache.accumulo.examples.simple.shard.Index;
import org.apache.accumulo.examples.simple.shard.Query;
import org.apache.accumulo.examples.simple.shard.Reverse;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.categories.StandaloneCapableClusterTests;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Tool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StandaloneCapableClusterTests.class, SunnyDayTests.class})
public class ExamplesIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ExamplesIT.class);
    private static final BatchWriterOpts bwOpts = new BatchWriterOpts();
    private static final BatchWriterConfig bwc = new BatchWriterConfig();
    private static final String visibility = "A|B";
    private static final String auths = "A,B";
    Connector c;
    String instance;
    String keepers;
    String user;
    String passwd;
    String keytab;
    BatchWriter bw;
    IteratorSetting is;
    String dir;
    FileSystem fs;
    Authorizations origAuths;
    boolean saslEnabled;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopConf) {
        cfg.setDefaultMemory(cfg.getDefaultMemory() * 3L, MemoryUnit.BYTE);
    }

    @Before
    public void getClusterInfo() throws Exception {
        this.c = this.getConnector();
        this.user = ExamplesIT.getAdminPrincipal();
        AuthenticationToken token = ExamplesIT.getAdminToken();
        if (token instanceof KerberosToken) {
            this.keytab = this.getAdminUser().getKeytab().getAbsolutePath();
            this.saslEnabled = true;
        } else if (token instanceof PasswordToken) {
            this.passwd = new String(((PasswordToken)ExamplesIT.getAdminToken()).getPassword(), StandardCharsets.UTF_8);
            this.saslEnabled = false;
        } else {
            Assert.fail((String)("Unknown token type: " + token));
        }
        this.fs = ExamplesIT.getCluster().getFileSystem();
        this.instance = this.c.getInstance().getInstanceName();
        this.keepers = this.c.getInstance().getZooKeepers();
        this.dir = new Path(cluster.getTemporaryPath(), this.getClass().getName()).toString();
        this.origAuths = this.c.securityOperations().getUserAuthorizations(this.user);
        this.c.securityOperations().changeUserAuthorizations(this.user, new Authorizations(auths.split(",")));
    }

    @After
    public void resetAuths() throws Exception {
        if (null != this.origAuths) {
            this.getConnector().securityOperations().changeUserAuthorizations(ExamplesIT.getAdminPrincipal(), this.origAuths);
        }
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 360;
    }

    @Test
    public void testTrace() throws Exception {
        Process trace = null;
        if (AccumuloClusterHarness.ClusterType.MINI == ExamplesIT.getClusterType()) {
            MiniAccumuloClusterImpl impl = (MiniAccumuloClusterImpl)cluster;
            trace = impl.exec(TraceServer.class, new String[0]);
            while (!this.c.tableOperations().exists("trace")) {
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-C", "-D", "-c"} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-C", "-D", "-c"};
        Map.Entry pair = cluster.getClusterControl().execWithStdout(TracingExample.class, args);
        Assert.assertEquals((String)("Expected return code of zero. STDOUT=" + (String)pair.getValue()), (long)0L, (long)((Integer)pair.getKey()).intValue());
        String result = (String)pair.getValue();
        Pattern pattern = Pattern.compile("TraceID: ([0-9a-f]+)");
        Matcher matcher = pattern.matcher(result);
        int count = 0;
        while (matcher.find()) {
            args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--traceid", matcher.group(1)} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--traceid", matcher.group(1)};
            pair = cluster.getClusterControl().execWithStdout(TraceDumpExample.class, args);
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output did not contain myApp@myHost", (boolean)((String)pair.getValue()).contains("myApp@myHost"));
        if (AccumuloClusterHarness.ClusterType.MINI == ExamplesIT.getClusterType() && null != trace) {
            trace.destroy();
        }
    }

    @Test
    public void testClasspath() throws Exception {
        Map.Entry entry = ExamplesIT.getCluster().getClusterControl().execWithStdout(Main.class, new String[]{"classpath"});
        Assert.assertEquals((long)0L, (long)((Integer)entry.getKey()).intValue());
        String result = (String)entry.getValue();
        int level1 = result.indexOf("Level 1");
        int level2 = result.indexOf("Level 2");
        int level3 = result.indexOf("Level 3");
        int level4 = result.indexOf("Level 4");
        Assert.assertTrue((String)"Level 1 classloader not present.", (level1 >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Level 2 classloader not present.", (level2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Level 3 classloader not present.", (level3 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Level 4 classloader not present.", (level4 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((level1 < level2 ? 1 : 0) != 0);
        Assert.assertTrue((level2 < level3 ? 1 : 0) != 0);
        Assert.assertTrue((level3 < level4 ? 1 : 0) != 0);
    }

    @Test
    public void testDirList() throws Exception {
        String expectedFile;
        String dirListDirectory;
        String[] names = this.getUniqueNames(3);
        String dirTable = names[0];
        String indexTable = names[1];
        String dataTable = names[2];
        switch (ExamplesIT.getClusterType()) {
            case MINI: {
                dirListDirectory = ((MiniAccumuloClusterImpl)ExamplesIT.getCluster()).getConfig().getDir().getAbsolutePath();
                break;
            }
            case STANDALONE: {
                dirListDirectory = ((StandaloneAccumuloCluster)ExamplesIT.getCluster()).getAccumuloHome();
                break;
            }
            default: {
                throw new RuntimeException("Unknown cluster type");
            }
        }
        Assume.assumeTrue((boolean)new File(dirListDirectory).exists());
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--dirTable", dirTable, "--indexTable", indexTable, "--dataTable", dataTable, "--vis", visibility, "--chunkSize", Integer.toString(10000), dirListDirectory} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--dirTable", dirTable, "--indexTable", indexTable, "--dataTable", dataTable, "--vis", visibility, "--chunkSize", Integer.toString(10000), dirListDirectory};
        Map.Entry entry = ExamplesIT.getClusterControl().execWithStdout(Ingest.class, args);
        Assert.assertEquals((String)("Got non-zero return code. Stdout=" + (String)entry.getValue()), (long)0L, (long)((Integer)entry.getKey()).intValue());
        switch (ExamplesIT.getClusterType()) {
            case MINI: {
                expectedFile = "accumulo-site.xml";
                break;
            }
            case STANDALONE: {
                expectedFile = "LICENSE";
                break;
            }
            default: {
                throw new RuntimeException("Unknown cluster type");
            }
        }
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "--keytab", this.keytab, "-u", this.user, "-t", indexTable, "--auths", auths, "--search", "--path", expectedFile} : new String[]{"-i", this.instance, "-z", this.keepers, "-p", this.passwd, "-u", this.user, "-t", indexTable, "--auths", auths, "--search", "--path", expectedFile};
        entry = ExamplesIT.getClusterControl().execWithStdout(QueryUtil.class, args);
        if (AccumuloClusterHarness.ClusterType.MINI == ExamplesIT.getClusterType()) {
            MiniAccumuloClusterImpl impl = (MiniAccumuloClusterImpl)cluster;
            for (MiniAccumuloClusterImpl.LogWriter writer : impl.getLogWriters()) {
                writer.flush();
            }
        }
        log.info("result " + (String)entry.getValue());
        Assert.assertEquals((long)0L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertTrue((boolean)((String)entry.getValue()).contains(expectedFile));
    }

    @Test
    public void testAgeoffFilter() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.c.tableOperations().create(tableName);
        this.is = new IteratorSetting(10, AgeOffFilter.class);
        AgeOffFilter.setTTL((IteratorSetting)this.is, (Long)1000L);
        this.c.tableOperations().attachIterator(tableName, this.is);
        UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.bw = this.c.createBatchWriter(tableName, bwc);
        Mutation m = new Mutation((CharSequence)"foo");
        m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"c");
        this.bw.addMutation(m);
        this.bw.close();
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)this.c.createScanner(tableName, Authorizations.EMPTY).iterator()));
    }

    @Test
    public void testStatsCombiner() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.c.tableOperations().create(table);
        this.is = new IteratorSetting(10, StatsCombiner.class);
        StatsCombiner.setCombineAllColumns((IteratorSetting)this.is, (boolean)true);
        this.c.tableOperations().attachIterator(table, this.is);
        this.bw = this.c.createBatchWriter(table, bwc);
        Mutation m = new Mutation((CharSequence)"foo");
        m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"1");
        this.bw.addMutation(m);
        m = new Mutation((CharSequence)"foo");
        m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"3");
        this.bw.addMutation(m);
        this.bw.flush();
        Iterator iter = this.c.createScanner(table, Authorizations.EMPTY).iterator();
        Assert.assertTrue((String)"Iterator had no results", (boolean)iter.hasNext());
        Map.Entry e = (Map.Entry)iter.next();
        Assert.assertEquals((String)"Results ", (Object)"1,3,4,2", (Object)((Value)e.getValue()).toString());
        Assert.assertFalse((String)"Iterator had additional results", (boolean)iter.hasNext());
        m = new Mutation((CharSequence)"foo");
        m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"0,20,20,2");
        this.bw.addMutation(m);
        this.bw.close();
        iter = this.c.createScanner(table, Authorizations.EMPTY).iterator();
        Assert.assertTrue((String)"Iterator had no results", (boolean)iter.hasNext());
        e = (Map.Entry)iter.next();
        Assert.assertEquals((String)"Results ", (Object)"0,20,24,4", (Object)((Value)e.getValue()).toString());
        Assert.assertFalse((String)"Iterator had additional results", (boolean)iter.hasNext());
    }

    @Test
    public void testBloomFilters() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.c.tableOperations().create(tableName);
        this.c.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        String[] args = this.saslEnabled ? new String[]{"--seed", "7", "-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--num", "100000", "--min", "0", "--max", "1000000000", "--size", "50", "--batchMemory", "2M", "--batchLatency", "60s", "--batchThreads", "3", "-t", tableName} : new String[]{"--seed", "7", "-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--num", "100000", "--min", "0", "--max", "1000000000", "--size", "50", "--batchMemory", "2M", "--batchLatency", "60s", "--batchThreads", "3", "-t", tableName};
        this.goodExec(RandomBatchWriter.class, args);
        this.c.tableOperations().flush(tableName, null, null, true);
        long diff = 0L;
        long diff2 = 0L;
        for (int i = 0; i < 2; ++i) {
            long now = System.currentTimeMillis();
            args = this.saslEnabled ? new String[]{"--seed", "7", "-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--num", "10000", "--min", "0", "--max", "1000000000", "--size", "50", "--scanThreads", "4", "-t", tableName} : new String[]{"--seed", "7", "-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--num", "10000", "--min", "0", "--max", "1000000000", "--size", "50", "--scanThreads", "4", "-t", tableName};
            this.goodExec(RandomBatchScanner.class, args);
            diff = System.currentTimeMillis() - now;
            now = System.currentTimeMillis();
            args = this.saslEnabled ? new String[]{"--seed", "8", "-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--num", "10000", "--min", "0", "--max", "1000000000", "--size", "50", "--scanThreads", "4", "-t", tableName} : new String[]{"--seed", "8", "-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--num", "10000", "--min", "0", "--max", "1000000000", "--size", "50", "--scanThreads", "4", "-t", tableName};
            int retCode = ExamplesIT.getClusterControl().exec(RandomBatchScanner.class, args);
            Assert.assertEquals((long)1L, (long)retCode);
            diff2 = System.currentTimeMillis() - now;
            if (diff2 < diff) break;
        }
        Assert.assertTrue((diff2 < diff ? 1 : 0) != 0);
    }

    @Test
    public void testShardedIndex() throws Exception {
        File src = new File(System.getProperty("user.dir") + "/src");
        Assume.assumeTrue((boolean)src.exists());
        String[] names = this.getUniqueNames(3);
        String shard = names[0];
        String index = names[1];
        this.c.tableOperations().create(shard);
        this.c.tableOperations().create(index);
        this.bw = this.c.createBatchWriter(shard, bwc);
        Index.index((int)30, (File)src, (String)"\\W+", (BatchWriter)this.bw);
        this.bw.close();
        BatchScanner bs = this.c.createBatchScanner(shard, Authorizations.EMPTY, 4);
        List found = Query.query((BatchScanner)bs, Arrays.asList("foo", "bar"), null);
        bs.close();
        boolean thisFile = false;
        for (String file : found) {
            if (!file.endsWith("/ExamplesIT.java")) continue;
            thisFile = true;
        }
        Assert.assertTrue((boolean)thisFile);
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "--shardTable", shard, "--doc2Term", index, "-u", this.user, "--keytab", this.keytab} : new String[]{"-i", this.instance, "-z", this.keepers, "--shardTable", shard, "--doc2Term", index, "-u", ExamplesIT.getAdminPrincipal(), "-p", this.passwd};
        this.goodExec(Reverse.class, args);
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "--shardTable", shard, "--doc2Term", index, "-u", this.user, "--keytab", this.keytab, "--terms", "5", "--count", "1000"} : new String[]{"-i", this.instance, "-z", this.keepers, "--shardTable", shard, "--doc2Term", index, "-u", this.user, "-p", this.passwd, "--terms", "5", "--count", "1000"};
        this.goodExec(ContinuousQuery.class, args);
    }

    @Test
    public void testMaxMutationConstraint() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.c.tableOperations().create(tableName);
        this.c.tableOperations().addConstraint(tableName, MaxMutationSize.class.getName());
        TestIngest.Opts opts = new TestIngest.Opts();
        opts.rows = 1;
        opts.cols = 1000;
        opts.setTableName(tableName);
        if (this.saslEnabled) {
            opts.updateKerberosCredentials(cluster.getClientConfig());
        } else {
            opts.setPrincipal(ExamplesIT.getAdminPrincipal());
        }
        try {
            TestIngest.ingest(this.c, opts, bwOpts);
        }
        catch (MutationsRejectedException ex) {
            Assert.assertEquals((long)1L, (long)ex.getConstraintViolationSummaries().size());
        }
    }

    @Test
    public void testBulkIngest() throws Exception {
        Assume.assumeTrue((boolean)(ExamplesIT.getAdminToken() instanceof PasswordToken));
        String tableName = this.getUniqueNames(1)[0];
        FileSystem fs = ExamplesIT.getFileSystem();
        Path p = new Path(this.dir, "tmp");
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        this.goodExec(GenerateTestData.class, "--start-row", "0", "--count", "10000", "--output", this.dir + "/tmp/input/data");
        ArrayList<String> commonArgs = new ArrayList<String>(Arrays.asList("-i", this.instance, "-z", this.keepers, "-u", this.user, "--table", tableName));
        if (this.saslEnabled) {
            commonArgs.add("--keytab");
            commonArgs.add(this.keytab);
        } else {
            commonArgs.add("-p");
            commonArgs.add(this.passwd);
        }
        ArrayList<String> args = new ArrayList<String>(commonArgs);
        this.goodExec(SetupTable.class, args.toArray(new String[0]));
        args = new ArrayList<String>(commonArgs);
        args.addAll(Arrays.asList("--inputDir", this.dir + "/tmp/input", "--workDir", this.dir + "/tmp"));
        this.goodExec(BulkIngestExample.class, args.toArray(new String[0]));
        args = new ArrayList<String>(commonArgs);
        args.addAll(Arrays.asList("--start-row", "0", "--count", "10000"));
        this.goodExec(VerifyIngest.class, args.toArray(new String[0]));
    }

    @Test
    public void testTeraSortAndRead() throws Exception {
        Assume.assumeTrue((boolean)(ExamplesIT.getAdminToken() instanceof PasswordToken));
        String tableName = this.getUniqueNames(1)[0];
        String[] args = this.saslEnabled ? new String[]{"--count", "1000000", "-nk", "10", "-xk", "10", "-nv", "10", "-xv", "10", "-t", tableName, "-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--splits", "4"} : new String[]{"--count", "1000000", "-nk", "10", "-xk", "10", "-nv", "10", "-xv", "10", "-t", tableName, "-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--splits", "4"};
        this.goodExec(TeraSortIngest.class, args);
        Path output = new Path(this.dir, "tmp/nines");
        if (this.fs.exists(output)) {
            this.fs.delete(output, true);
        }
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-t", tableName, "--rowRegex", ".*999.*", "--output", output.toString()} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-t", tableName, "--rowRegex", ".*999.*", "--output", output.toString()};
        this.goodExec(RegexExample.class, args);
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-t", tableName, "--column", "c:"} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-t", tableName, "--column", "c:"};
        this.goodExec(RowHash.class, args);
        output = new Path(this.dir, "tmp/tableFile");
        if (this.fs.exists(output)) {
            this.fs.delete(output, true);
        }
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-t", tableName, "--output", output.toString()} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-t", tableName, "--output", output.toString()};
        this.goodExec(TableToFile.class, args);
    }

    @Test
    public void testWordCount() throws Exception {
        Assume.assumeTrue((boolean)(ExamplesIT.getAdminToken() instanceof PasswordToken));
        String tableName = this.getUniqueNames(1)[0];
        this.c.tableOperations().create(tableName);
        this.is = new IteratorSetting(10, SummingCombiner.class);
        SummingCombiner.setColumns((IteratorSetting)this.is, Collections.singletonList(new IteratorSetting.Column(new Text("count"))));
        SummingCombiner.setEncodingType((IteratorSetting)this.is, (LongCombiner.Type)LongCombiner.Type.STRING);
        this.c.tableOperations().attachIterator(tableName, this.is);
        Path readme = new Path(new Path(System.getProperty("user.dir")).getParent(), "README.md");
        if (!new File(readme.toString()).exists()) {
            log.info("Not running test: README.md does not exist)");
            return;
        }
        this.fs.copyFromLocalFile(readme, new Path(this.dir + "/tmp/wc/README.md"));
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-u", this.user, "--keytab", this.keytab, "-z", this.keepers, "--input", this.dir + "/tmp/wc", "-t", tableName} : new String[]{"-i", this.instance, "-u", this.user, "-p", this.passwd, "-z", this.keepers, "--input", this.dir + "/tmp/wc", "-t", tableName};
        this.goodExec(WordCount.class, args);
    }

    @Test
    public void testInsertWithBatchWriterAndReadData() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-t", tableName} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-t", tableName};
        this.goodExec(InsertWithBatchWriter.class, args);
        this.goodExec(ReadData.class, args);
    }

    @Test
    public void testIsolatedScansWithInterference() throws Exception {
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-t", this.getUniqueNames(1)[0], "--iterations", "100000", "--isolated"} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-t", this.getUniqueNames(1)[0], "--iterations", "100000", "--isolated"};
        this.goodExec(InterferenceTest.class, args);
    }

    @Test
    public void testScansWithInterference() throws Exception {
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-t", this.getUniqueNames(1)[0], "--iterations", "100000"} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-t", this.getUniqueNames(1)[0], "--iterations", "100000"};
        this.goodExec(InterferenceTest.class, args);
    }

    @Test
    public void testRowOperations() throws Exception {
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd};
        this.goodExec(RowOperations.class, args);
    }

    @Test
    public void testBatchWriter() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.c.tableOperations().create(tableName);
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "-t", tableName, "--start", "0", "--num", "100000", "--size", "50", "--batchMemory", "10000000", "--batchLatency", "1000", "--batchThreads", "4", "--vis", visibility} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "-t", tableName, "--start", "0", "--num", "100000", "--size", "50", "--batchMemory", "10000000", "--batchLatency", "1000", "--batchThreads", "4", "--vis", visibility};
        this.goodExec(SequentialBatchWriter.class, args);
    }

    @Test
    public void testReadWriteAndDelete() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--auths", auths, "--table", tableName, "--createtable", "-c", "--debug"} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--auths", auths, "--table", tableName, "--createtable", "-c", "--debug"};
        this.goodExec(ReadWriteExample.class, args);
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--auths", auths, "--table", tableName, "-d", "--debug"} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--auths", auths, "--table", tableName, "-d", "--debug"};
        this.goodExec(ReadWriteExample.class, args);
    }

    @Test
    public void testRandomBatchesAndFlush() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.c.tableOperations().create(tableName);
        String[] args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--table", tableName, "--num", "100000", "--min", "0", "--max", "100000", "--size", "100", "--batchMemory", "1000000", "--batchLatency", "1000", "--batchThreads", "4", "--vis", visibility} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--table", tableName, "--num", "100000", "--min", "0", "--max", "100000", "--size", "100", "--batchMemory", "1000000", "--batchLatency", "1000", "--batchThreads", "4", "--vis", visibility};
        this.goodExec(RandomBatchWriter.class, args);
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--table", tableName, "--num", "10000", "--min", "0", "--max", "100000", "--size", "100", "--scanThreads", "4", "--auths", auths} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--table", tableName, "--num", "10000", "--min", "0", "--max", "100000", "--size", "100", "--scanThreads", "4", "--auths", auths};
        this.goodExec(RandomBatchScanner.class, args);
        args = this.saslEnabled ? new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "--keytab", this.keytab, "--table", tableName} : new String[]{"-i", this.instance, "-z", this.keepers, "-u", this.user, "-p", this.passwd, "--table", tableName};
        this.goodExec(Flush.class, args);
    }

    private void goodExec(Class<?> theClass, String ... args) throws InterruptedException, IOException {
        Map.Entry pair;
        if (Tool.class.isAssignableFrom(theClass) && AccumuloClusterHarness.ClusterType.STANDALONE == ExamplesIT.getClusterType()) {
            StandaloneClusterControl control = (StandaloneClusterControl)ExamplesIT.getClusterControl();
            pair = control.execMapreduceWithStdout(theClass, args);
        } else {
            pair = ExamplesIT.getClusterControl().execWithStdout(theClass, args);
        }
        Assert.assertEquals((String)("stdout=" + (String)pair.getValue()), (long)0L, (long)((Integer)pair.getKey()).intValue());
    }
}

