/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyMetricsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(LegacyMetricsIT.class);

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.GENERAL_LEGACY_METRICS, "true");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void useMaster() {
        boolean legacyMetricsEnabled = cluster.getSiteConfiguration().getBoolean(Property.GENERAL_LEGACY_METRICS);
        Assert.assertTrue((boolean)legacyMetricsEnabled);
        ArrayList<String> tables = new ArrayList<String>();
        int tableCount = 4;
        for (int i = 0; i < tableCount; ++i) {
            String uniqueName = this.getUniqueNames(1)[0] + "_" + i;
            tables.add(uniqueName);
            try {
                this.getConnector().tableOperations().create(uniqueName);
                continue;
            }
            catch (AccumuloException | AccumuloSecurityException | TableExistsException ex) {
                log.debug("Failed to create table: {}", (Object)uniqueName, (Object)ex);
                Assert.fail((String)("failed to create table: " + uniqueName));
            }
        }
        try {
            this.getConnector().instanceOperations().waitForBalance();
            Map configs = this.getConnector().instanceOperations().getSystemConfiguration();
            Assert.assertFalse((String)"master config should not be empty", (boolean)configs.isEmpty());
        }
        catch (AccumuloException | AccumuloSecurityException ex) {
            Assert.fail((String)"Could not get config from master");
        }
        for (String t : tables) {
            try {
                log.debug("Delete test table: {}", (Object)t);
                this.getConnector().tableOperations().delete(t);
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException ex) {
                log.debug("Exception thrown deleting table during test clean-up", ex);
            }
        }
    }
}

