/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;

public class MasterFailoverIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 90;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        String[] names = this.getUniqueNames(2);
        c.tableOperations().create(names[0]);
        TestIngest.Opts opts = new TestIngest.Opts();
        opts.setTableName(names[0]);
        ClientConfiguration clientConf = cluster.getClientConfig();
        if (clientConf.hasSasl()) {
            opts.updateKerberosCredentials(clientConf);
        } else {
            opts.setPrincipal(MasterFailoverIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        ClusterControl control = cluster.getClusterControl();
        control.stopAllServers(ServerType.MASTER);
        control.startAllServers(ServerType.MASTER);
        c.tableOperations().rename(names[0], names[1]);
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        vopts.setTableName(names[1]);
        if (clientConf.hasSasl()) {
            vopts.updateKerberosCredentials(clientConf);
        } else {
            vopts.setPrincipal(MasterFailoverIT.getAdminPrincipal());
        }
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
    }
}

