/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SunnyDayTests.class})
public class NativeMapIT {
    private Key newKey(int r) {
        return new Key(new Text(String.format("r%09d", r)));
    }

    private Key newKey(int r, int cf, int cq, int cv, int ts, boolean deleted) {
        Key k = new Key(new Text(String.format("r%09d", r)), new Text(String.format("cf%09d", cf)), new Text(String.format("cq%09d", cq)), new Text(String.format("cv%09d", cv)), (long)ts);
        k.setDeleted(deleted);
        return k;
    }

    private Value newValue(int v) {
        return new Value(String.format("r%09d", v).getBytes(StandardCharsets.UTF_8));
    }

    public static File nativeMapLocation() {
        File projectDir = new File(System.getProperty("user.dir")).getParentFile();
        File nativeMapDir = new File(projectDir, "server/native/target/accumulo-native-1.10.4/accumulo-native-1.10.4");
        return nativeMapDir;
    }

    @BeforeClass
    public static void setUp() {
        NativeMap.loadNativeLib(Collections.singletonList(NativeMapIT.nativeMapLocation()));
    }

    private void verifyIterator(int start, int end, int valueOffset, Iterator<Map.Entry<Key, Value>> iter) {
        for (int i = start; i <= end; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            Map.Entry<Key, Value> entry = iter.next();
            Assert.assertEquals((Object)this.newKey(i), (Object)entry.getKey());
            Assert.assertEquals((Object)this.newValue(i + valueOffset), (Object)entry.getValue());
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private void insertAndVerify(NativeMap nm, int start, int end, int valueOffset) {
        int i;
        for (i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i + valueOffset));
        }
        for (i = start; i <= end; ++i) {
            Value v = nm.get(this.newKey(i));
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((Object)this.newValue(i + valueOffset), (Object)v);
            Iterator iter2 = nm.iterator(this.newKey(i));
            Assert.assertTrue((boolean)iter2.hasNext());
            Map.Entry entry = (Map.Entry)iter2.next();
            Assert.assertEquals((Object)this.newKey(i), entry.getKey());
            Assert.assertEquals((Object)this.newValue(i + valueOffset), entry.getValue());
        }
        Assert.assertNull((Object)nm.get(this.newKey(start - 1)));
        Assert.assertNull((Object)nm.get(this.newKey(end + 1)));
        Iterator iter = nm.iterator();
        this.verifyIterator(start, end, valueOffset, iter);
        for (int i2 = start; i2 <= end; ++i2) {
            iter = nm.iterator(this.newKey(i2));
            this.verifyIterator(i2, end, valueOffset, iter);
            iter = nm.iterator(this.newKey(i2, 1, 1, 1, 1, false));
            this.verifyIterator(i2 + 1, end, valueOffset, iter);
        }
        Assert.assertEquals((long)(end - start + 1), (long)nm.size());
    }

    private void insertAndVerifyExhaustive(NativeMap nm, int num, int run) {
        Value value;
        Key key;
        int l;
        int k;
        int j;
        int i;
        for (int i2 = 0; i2 < num; ++i2) {
            for (int j2 = 0; j2 < num; ++j2) {
                for (int k2 = 0; k2 < num; ++k2) {
                    for (int l2 = 0; l2 < num; ++l2) {
                        for (int ts = 0; ts < num; ++ts) {
                            Key key2 = this.newKey(i2, j2, k2, l2, ts, true);
                            Value value2 = new Value((i2 + "_" + j2 + "_" + k2 + "_" + l2 + "_" + ts + "_" + true + "_" + run).getBytes(StandardCharsets.UTF_8));
                            nm.put(key2, value2);
                            key2 = this.newKey(i2, j2, k2, l2, ts, false);
                            value2 = new Value((i2 + "_" + j2 + "_" + k2 + "_" + l2 + "_" + ts + "_" + false + "_" + run).getBytes(StandardCharsets.UTF_8));
                            nm.put(key2, value2);
                        }
                    }
                }
            }
        }
        Iterator iter = nm.iterator();
        for (i = 0; i < num; ++i) {
            for (j = 0; j < num; ++j) {
                for (k = 0; k < num; ++k) {
                    for (l = 0; l < num; ++l) {
                        for (int ts = num - 1; ts >= 0; --ts) {
                            key = this.newKey(i, j, k, l, ts, true);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + true + "_" + run).getBytes(StandardCharsets.UTF_8));
                            Assert.assertTrue((boolean)iter.hasNext());
                            Map.Entry entry = (Map.Entry)iter.next();
                            Assert.assertEquals((Object)key, entry.getKey());
                            Assert.assertEquals((Object)value, entry.getValue());
                            key = this.newKey(i, j, k, l, ts, false);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + false + "_" + run).getBytes(StandardCharsets.UTF_8));
                            Assert.assertTrue((boolean)iter.hasNext());
                            entry = (Map.Entry)iter.next();
                            Assert.assertEquals((Object)key, entry.getKey());
                            Assert.assertEquals((Object)value, entry.getValue());
                        }
                    }
                }
            }
        }
        Assert.assertFalse((boolean)iter.hasNext());
        for (i = 0; i < num; ++i) {
            for (j = 0; j < num; ++j) {
                for (k = 0; k < num; ++k) {
                    for (l = 0; l < num; ++l) {
                        for (int ts = 0; ts < num; ++ts) {
                            key = this.newKey(i, j, k, l, ts, true);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + true + "_" + run).getBytes(StandardCharsets.UTF_8));
                            Assert.assertEquals((Object)value, (Object)nm.get(key));
                            Iterator iter2 = nm.iterator(key);
                            Assert.assertTrue((boolean)iter2.hasNext());
                            Map.Entry entry = (Map.Entry)iter2.next();
                            Assert.assertEquals((Object)key, entry.getKey());
                            Assert.assertEquals((Object)value, entry.getValue());
                            key = this.newKey(i, j, k, l, ts, false);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + false + "_" + run).getBytes(StandardCharsets.UTF_8));
                            Assert.assertEquals((Object)value, (Object)nm.get(key));
                            Iterator iter3 = nm.iterator(key);
                            Assert.assertTrue((boolean)iter3.hasNext());
                            Map.Entry entry2 = (Map.Entry)iter3.next();
                            Assert.assertEquals((Object)key, entry2.getKey());
                            Assert.assertEquals((Object)value, entry2.getValue());
                        }
                    }
                }
            }
        }
        Assert.assertEquals((long)(num * num * num * num * num * 2), (long)nm.size());
    }

    @Test
    public void test1() {
        NativeMap nm = new NativeMap();
        Iterator iter = nm.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        nm.delete();
    }

    @Test
    public void test2() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        this.insertAndVerify(nm, 1, 10, 1);
        this.insertAndVerify(nm, 1, 10, 2);
        nm.delete();
    }

    @Test
    public void test4() {
        NativeMap nm = new NativeMap();
        this.insertAndVerifyExhaustive(nm, 3, 0);
        this.insertAndVerifyExhaustive(nm, 3, 1);
        nm.delete();
    }

    @Test
    public void test5() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        Iterator iter = nm.iterator();
        iter.next();
        nm.delete();
        try {
            nm.put(this.newKey(1), this.newValue(1));
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            nm.get(this.newKey(1));
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            nm.iterator();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            nm.iterator(this.newKey(1));
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            nm.size();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            iter.next();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test7() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        nm.delete();
        try {
            nm.delete();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test8() {
        NativeMap nm = new NativeMap();
        TreeMap<Key, Value> tm = new TreeMap<Key, Value>();
        tm.put(new Key(new Text("fo")), new Value(new byte[]{48}));
        tm.put(new Key(new Text("foo")), new Value(new byte[]{49}));
        tm.put(new Key(new Text("foo1")), new Value(new byte[]{50}));
        tm.put(new Key(new Text("foo2")), new Value(new byte[]{51}));
        for (Map.Entry entry : tm.entrySet()) {
            nm.put((Key)entry.getKey(), (Value)entry.getValue());
        }
        Iterator iter = nm.iterator();
        for (Map.Entry entry : tm.entrySet()) {
            Assert.assertTrue((boolean)iter.hasNext());
            Map.Entry entry2 = (Map.Entry)iter.next();
            Assert.assertEquals(entry.getKey(), entry2.getKey());
            Assert.assertEquals(entry.getValue(), entry2.getValue());
        }
        Assert.assertFalse((boolean)iter.hasNext());
        nm.delete();
    }

    @Test
    public void test9() {
        NativeMap nm = new NativeMap();
        Iterator iter = nm.iterator();
        try {
            iter.next();
            Assert.assertTrue((boolean)false);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.insertAndVerify(nm, 1, 1, 0);
        iter = nm.iterator();
        iter.next();
        try {
            iter.next();
            Assert.assertTrue((boolean)false);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        nm.delete();
    }

    @Test
    public void test10() {
        int start = 1;
        int end = 10000;
        NativeMap nm = new NativeMap();
        for (int i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i));
        }
        long mem1 = nm.getMemoryUsed();
        for (int i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i));
        }
        long mem2 = nm.getMemoryUsed();
        if (mem1 != mem2) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem1 + " " + mem2);
        }
        for (int i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i));
        }
        long mem3 = nm.getMemoryUsed();
        if (mem1 != mem3) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem1 + " " + mem3);
        }
        byte[] bigrow = new byte[1000000];
        byte[] bigvalue = new byte[bigrow.length];
        for (int i = 0; i < bigrow.length; ++i) {
            bigrow[i] = (byte)(0xFF & i % 256);
            bigvalue[i] = bigrow[i];
        }
        nm.put(new Key(new Text(bigrow)), new Value(bigvalue));
        long mem4 = nm.getMemoryUsed();
        Value val = nm.get(new Key(new Text(bigrow)));
        if (val == null || !val.equals((Object)new Value(bigvalue))) {
            throw new RuntimeException("Did not get expected big value");
        }
        nm.put(new Key(new Text(bigrow)), new Value(bigvalue));
        long mem5 = nm.getMemoryUsed();
        if (mem4 != mem5) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem4 + " " + mem5);
        }
        val = nm.get(new Key(new Text(bigrow)));
        if (val == null || !val.equals((Object)new Value(bigvalue))) {
            throw new RuntimeException("Did not get expected big value");
        }
        nm.delete();
    }

    private static byte[] getRandomBytes(Random r, int maxLen) {
        int len = r.nextInt(maxLen);
        byte[] f = new byte[len];
        r.nextBytes(f);
        return f;
    }

    @Test
    public void test11() {
        NativeMap nm = new NativeMap();
        Random r = new Random(75L);
        ArrayList<Pair> testData = new ArrayList<Pair>();
        for (int i = 0; i < 100000; ++i) {
            Key k = new Key(NativeMapIT.getRandomBytes(r, 97), NativeMapIT.getRandomBytes(r, 13), NativeMapIT.getRandomBytes(r, 31), NativeMapIT.getRandomBytes(r, 11), r.nextLong() & Long.MAX_VALUE, false, false);
            Value v = new Value(NativeMapIT.getRandomBytes(r, 511));
            testData.add(new Pair((Object)k, (Object)v));
        }
        for (Pair pair : testData) {
            nm.put((Key)pair.getFirst(), (Value)pair.getSecond());
        }
        for (int i = 0; i < 2; ++i) {
            Collections.sort(testData, new Comparator<Pair<Key, Value>>(){

                @Override
                public int compare(Pair<Key, Value> o1, Pair<Key, Value> o2) {
                    return ((Key)o1.getFirst()).compareTo((Key)o2.getFirst());
                }
            });
            Iterator iter1 = nm.iterator();
            Iterator iter2 = testData.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Map.Entry e = (Map.Entry)iter1.next();
                Pair p = (Pair)iter2.next();
                if (!((Key)e.getKey()).equals(p.getFirst())) {
                    throw new RuntimeException("Keys not equal");
                }
                if (((Value)e.getValue()).equals(p.getSecond())) continue;
                throw new RuntimeException("Values not equal");
            }
            if (iter1.hasNext()) {
                throw new RuntimeException("Not all of native map consumed");
            }
            if (iter2.hasNext()) {
                throw new RuntimeException("Not all of test data consumed");
            }
            System.out.println("test 11 nm mem " + nm.getMemoryUsed());
            Collections.shuffle(testData, r);
            for (Pair pair : testData) {
                ((Value)pair.getSecond()).set(NativeMapIT.getRandomBytes(r, 511));
                nm.put((Key)pair.getFirst(), (Value)pair.getSecond());
            }
        }
        nm.delete();
    }

    @Test
    public void testBinary() {
        Value v;
        Key k;
        byte[] data;
        byte[] row;
        int i;
        NativeMap nm = new NativeMap();
        byte[] emptyBytes = new byte[]{};
        for (int i2 = 0; i2 < 256; ++i2) {
            for (int j = 0; j < 256; ++j) {
                byte[] row2 = new byte[]{114, (byte)(0xFF & i2), (byte)(0xFF & j)};
                byte[] data2 = new byte[]{118, (byte)(0xFF & i2), (byte)(0xFF & j)};
                Key k2 = new Key(row2, emptyBytes, emptyBytes, emptyBytes, 1L);
                Value v2 = new Value(data2);
                nm.put(k2, v2);
            }
        }
        Iterator iter = nm.iterator();
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                row = new byte[]{114, (byte)(0xFF & i), (byte)(0xFF & j)};
                data = new byte[]{118, (byte)(0xFF & i), (byte)(0xFF & j)};
                k = new Key(row, emptyBytes, emptyBytes, emptyBytes, 1L);
                v = new Value(data);
                Assert.assertTrue((boolean)iter.hasNext());
                Map.Entry entry = (Map.Entry)iter.next();
                Assert.assertEquals((Object)k, entry.getKey());
                Assert.assertEquals((Object)v, entry.getValue());
            }
        }
        Assert.assertFalse((boolean)iter.hasNext());
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                row = new byte[]{114, (byte)(0xFF & i), (byte)(0xFF & j)};
                data = new byte[]{118, (byte)(0xFF & i), (byte)(0xFF & j)};
                k = new Key(row, emptyBytes, emptyBytes, emptyBytes, 1L);
                v = new Value(data);
                Value v2 = nm.get(k);
                Assert.assertEquals((Object)v, (Object)v2);
            }
        }
        nm.delete();
    }

    @Test
    public void testEmpty() {
        NativeMap nm = new NativeMap();
        Assert.assertTrue((nm.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((nm.getMemoryUsed() == 0L ? 1 : 0) != 0);
        nm.delete();
    }

    @Test
    public void testConcurrentIter() throws IOException {
        NativeMap nm = new NativeMap();
        nm.put(this.newKey(0), this.newValue(0));
        nm.put(this.newKey(1), this.newValue(1));
        nm.put(this.newKey(3), this.newValue(3));
        SortedKeyValueIterator iter = nm.skvIterator();
        nm.put(this.newKey(2), this.newValue(2));
        Assert.assertTrue((boolean)iter.hasTop());
        Assert.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(0));
        iter.next();
        Assert.assertTrue((boolean)iter.hasTop());
        Assert.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(1));
        iter.next();
        Assert.assertTrue((boolean)iter.hasTop());
        Assert.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(2));
        iter.next();
        Assert.assertTrue((boolean)iter.hasTop());
        Assert.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(3));
        iter.next();
        Assert.assertFalse((boolean)iter.hasTop());
        nm.delete();
    }
}

