/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class})
public class PermissionsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(PermissionsIT.class);

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Before
    public void limitToMini() throws Exception {
        Assume.assumeTrue((AccumuloClusterHarness.ClusterType.MINI == PermissionsIT.getClusterType() ? 1 : 0) != 0);
        Connector c = this.getConnector();
        Set users = c.securityOperations().listLocalUsers();
        ClusterUser user = this.getUser(0);
        if (users.contains(user.getPrincipal())) {
            c.securityOperations().dropLocalUser(user.getPrincipal());
        }
    }

    private void loginAs(ClusterUser user) throws IOException {
        user.getToken();
    }

    @Test
    public void systemPermissionsTest() throws Exception {
        ClusterUser testUser = this.getUser(0);
        ClusterUser rootUser = this.getAdminUser();
        Connector c = this.getConnector();
        this.verifyHasOnlyTheseSystemPermissions(c, c.whoami(), SystemPermission.values());
        String principal = testUser.getPrincipal();
        AuthenticationToken token = testUser.getToken();
        PasswordToken passwordToken = null;
        if (token instanceof PasswordToken) {
            passwordToken = (PasswordToken)token;
        }
        this.loginAs(rootUser);
        c.securityOperations().createLocalUser(principal, passwordToken);
        this.loginAs(testUser);
        Connector test_user_conn = c.getInstance().getConnector(principal, token);
        this.loginAs(rootUser);
        this.verifyHasNoSystemPermissions(c, principal, SystemPermission.values());
        for (SystemPermission perm : SystemPermission.values()) {
            log.debug("Verifying the " + perm + " permission");
            String tableNamePrefix = this.getUniqueNames(1)[0];
            this.testMissingSystemPermission(tableNamePrefix, c, rootUser, test_user_conn, testUser, perm);
            this.loginAs(rootUser);
            c.securityOperations().grantSystemPermission(principal, perm);
            this.verifyHasOnlyTheseSystemPermissions(c, principal, perm);
            this.testGrantedSystemPermission(tableNamePrefix, c, rootUser, test_user_conn, testUser, perm);
            this.loginAs(rootUser);
            c.securityOperations().revokeSystemPermission(principal, perm);
            this.verifyHasNoSystemPermissions(c, principal, perm);
        }
    }

    static Map<String, String> map(Iterable<Map.Entry<String, String>> i) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> e : i) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    private void testMissingSystemPermission(String tableNamePrefix, Connector root_conn, ClusterUser rootUser, Connector test_user_conn, ClusterUser testUser, SystemPermission perm) throws Exception {
        String password = "password";
        boolean passwordBased = testUser.getPassword() != null;
        log.debug("Confirming that the lack of the " + perm + " permission properly restricts the user");
        switch (perm) {
            case CREATE_TABLE: {
                String tableName = tableNamePrefix + "__CREATE_TABLE_WITHOUT_PERM_TEST__";
                try {
                    this.loginAs(testUser);
                    test_user_conn.tableOperations().create(tableName);
                    throw new IllegalStateException("Should NOT be able to create a table");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && !root_conn.tableOperations().list().contains(tableName)) break;
                    throw e;
                }
            }
            case DROP_TABLE: {
                String tableName = tableNamePrefix + "__DROP_TABLE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.tableOperations().create(tableName);
                try {
                    this.loginAs(testUser);
                    test_user_conn.tableOperations().delete(tableName);
                    throw new IllegalStateException("Should NOT be able to delete a table");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.tableOperations().list().contains(tableName)) break;
                    throw e;
                }
            }
            case ALTER_TABLE: {
                String tableName = tableNamePrefix + "__ALTER_TABLE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.tableOperations().create(tableName);
                try {
                    this.loginAs(testUser);
                    test_user_conn.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                    throw new IllegalStateException("Should NOT be able to set a table property");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || PermissionsIT.map(root_conn.tableOperations().getProperties(tableName)).get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                        throw e;
                    }
                    this.loginAs(rootUser);
                    root_conn.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                    try {
                        this.loginAs(testUser);
                        test_user_conn.tableOperations().removeProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey());
                        throw new IllegalStateException("Should NOT be able to remove a table property");
                    }
                    catch (AccumuloSecurityException e2) {
                        this.loginAs(rootUser);
                        if (e2.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || !PermissionsIT.map(root_conn.tableOperations().getProperties(tableName)).get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                            throw e2;
                        }
                        String table2 = tableName + "2";
                        try {
                            this.loginAs(testUser);
                            test_user_conn.tableOperations().rename(tableName, table2);
                            throw new IllegalStateException("Should NOT be able to rename a table");
                        }
                        catch (AccumuloSecurityException e3) {
                            this.loginAs(rootUser);
                            if (e3.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.tableOperations().list().contains(tableName) && !root_conn.tableOperations().list().contains(table2)) break;
                            throw e3;
                        }
                    }
                }
            }
            case CREATE_USER: {
                String user = "__CREATE_USER_WITHOUT_PERM_TEST__";
                try {
                    this.loginAs(testUser);
                    test_user_conn.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                    throw new IllegalStateException("Should NOT be able to create a user");
                }
                catch (AccumuloSecurityException e) {
                    AuthenticationToken userToken = testUser.getToken();
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && (!(userToken instanceof PasswordToken) || !root_conn.securityOperations().authenticateUser(user, userToken))) break;
                    throw e;
                }
            }
            case DROP_USER: {
                String user = "__DROP_USER_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                try {
                    this.loginAs(testUser);
                    test_user_conn.securityOperations().dropLocalUser(user);
                    throw new IllegalStateException("Should NOT be able to delete a user");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.securityOperations().listLocalUsers().contains(user)) break;
                    log.info("Failed to authenticate as " + user);
                    throw e;
                }
            }
            case ALTER_USER: {
                String user = "__ALTER_USER_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                try {
                    this.loginAs(testUser);
                    test_user_conn.securityOperations().changeUserAuthorizations(user, new Authorizations(new String[]{"A", "B"}));
                    throw new IllegalStateException("Should NOT be able to alter a user");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.securityOperations().getUserAuthorizations(user).isEmpty()) break;
                    throw e;
                }
            }
            case SYSTEM: {
                try {
                    this.loginAs(testUser);
                    test_user_conn.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "10000");
                    throw new IllegalStateException("Should NOT be able to set System Property");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || ((String)root_conn.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) {
                        throw e;
                    }
                    this.loginAs(rootUser);
                    root_conn.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "10000");
                    try {
                        this.loginAs(testUser);
                        test_user_conn.instanceOperations().removeProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey());
                        throw new IllegalStateException("Should NOT be able to remove Sysem Property");
                    }
                    catch (AccumuloSecurityException e4) {
                        this.loginAs(rootUser);
                        if (e4.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && ((String)root_conn.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) break;
                        throw e4;
                    }
                }
            }
            case CREATE_NAMESPACE: {
                String namespace = "__CREATE_NAMESPACE_WITHOUT_PERM_TEST__";
                try {
                    this.loginAs(testUser);
                    test_user_conn.namespaceOperations().create(namespace);
                    throw new IllegalStateException("Should NOT be able to create a namespace");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && !root_conn.namespaceOperations().list().contains(namespace)) break;
                    throw e;
                }
            }
            case DROP_NAMESPACE: {
                String namespace = "__DROP_NAMESPACE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.namespaceOperations().create(namespace);
                try {
                    this.loginAs(testUser);
                    test_user_conn.namespaceOperations().delete(namespace);
                    throw new IllegalStateException("Should NOT be able to delete a namespace");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.namespaceOperations().list().contains(namespace)) break;
                    throw e;
                }
            }
            case ALTER_NAMESPACE: {
                String namespace = "__ALTER_NAMESPACE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.namespaceOperations().create(namespace);
                try {
                    this.loginAs(testUser);
                    test_user_conn.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                    throw new IllegalStateException("Should NOT be able to set a namespace property");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || PermissionsIT.map(root_conn.namespaceOperations().getProperties(namespace)).get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                        throw e;
                    }
                    this.loginAs(rootUser);
                    root_conn.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                    try {
                        this.loginAs(testUser);
                        test_user_conn.namespaceOperations().removeProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey());
                        throw new IllegalStateException("Should NOT be able to remove a namespace property");
                    }
                    catch (AccumuloSecurityException e5) {
                        this.loginAs(rootUser);
                        if (e5.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || !PermissionsIT.map(root_conn.namespaceOperations().getProperties(namespace)).get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                            throw e5;
                        }
                        String namespace2 = namespace + "2";
                        try {
                            this.loginAs(testUser);
                            test_user_conn.namespaceOperations().rename(namespace, namespace2);
                            throw new IllegalStateException("Should NOT be able to rename a namespace");
                        }
                        catch (AccumuloSecurityException e6) {
                            this.loginAs(rootUser);
                            if (e6.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.namespaceOperations().list().contains(namespace) && !root_conn.namespaceOperations().list().contains(namespace2)) break;
                            throw e6;
                        }
                    }
                }
            }
            case OBTAIN_DELEGATION_TOKEN: {
                ClientConfiguration clientConf = cluster.getClientConfig();
                if (!clientConf.hasSasl()) break;
                break;
            }
            case GRANT: {
                this.loginAs(testUser);
                try {
                    test_user_conn.securityOperations().grantSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT);
                    throw new IllegalStateException("Should NOT be able to grant System.GRANT to yourself");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    Assert.assertFalse((boolean)root_conn.securityOperations().hasSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT));
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unrecognized System Permission: " + perm);
            }
        }
    }

    private void testGrantedSystemPermission(String tableNamePrefix, Connector root_conn, ClusterUser rootUser, Connector test_user_conn, ClusterUser testUser, SystemPermission perm) throws Exception {
        String password = "password";
        boolean passwordBased = testUser.getPassword() != null;
        log.debug("Confirming that the presence of the " + perm + " permission properly permits the user");
        switch (perm) {
            case CREATE_TABLE: {
                String tableName = tableNamePrefix + "__CREATE_TABLE_WITH_PERM_TEST__";
                this.loginAs(testUser);
                test_user_conn.tableOperations().create(tableName);
                this.loginAs(rootUser);
                if (root_conn.tableOperations().list().contains(tableName)) break;
                throw new IllegalStateException("Should be able to create a table");
            }
            case DROP_TABLE: {
                String tableName = tableNamePrefix + "__DROP_TABLE_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.tableOperations().create(tableName);
                this.loginAs(testUser);
                test_user_conn.tableOperations().delete(tableName);
                this.loginAs(rootUser);
                if (!root_conn.tableOperations().list().contains(tableName)) break;
                throw new IllegalStateException("Should be able to delete a table");
            }
            case ALTER_TABLE: {
                String tableName = tableNamePrefix + "__ALTER_TABLE_WITH_PERM_TEST__";
                String table2 = tableName + "2";
                this.loginAs(rootUser);
                root_conn.tableOperations().create(tableName);
                this.loginAs(testUser);
                test_user_conn.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                this.loginAs(rootUser);
                Map<String, String> properties = PermissionsIT.map(root_conn.tableOperations().getProperties(tableName));
                if (!properties.get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to set a table property");
                }
                this.loginAs(testUser);
                test_user_conn.tableOperations().removeProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey());
                this.loginAs(rootUser);
                properties = PermissionsIT.map(root_conn.tableOperations().getProperties(tableName));
                if (properties.get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to remove a table property");
                }
                this.loginAs(testUser);
                test_user_conn.tableOperations().rename(tableName, table2);
                this.loginAs(rootUser);
                if (!root_conn.tableOperations().list().contains(tableName) && root_conn.tableOperations().list().contains(table2)) break;
                throw new IllegalStateException("Should be able to rename a table");
            }
            case CREATE_USER: {
                String user = "__CREATE_USER_WITH_PERM_TEST__";
                this.loginAs(testUser);
                test_user_conn.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                this.loginAs(rootUser);
                if (!passwordBased || root_conn.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                throw new IllegalStateException("Should be able to create a user");
            }
            case DROP_USER: {
                String user = "__DROP_USER_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                this.loginAs(testUser);
                test_user_conn.securityOperations().dropLocalUser(user);
                this.loginAs(rootUser);
                if (!passwordBased || !root_conn.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                throw new IllegalStateException("Should be able to delete a user");
            }
            case ALTER_USER: {
                String user = "__ALTER_USER_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                this.loginAs(testUser);
                test_user_conn.securityOperations().changeUserAuthorizations(user, new Authorizations(new String[]{"A", "B"}));
                this.loginAs(rootUser);
                if (!root_conn.securityOperations().getUserAuthorizations(user).isEmpty()) break;
                throw new IllegalStateException("Should be able to alter a user");
            }
            case SYSTEM: {
                this.loginAs(testUser);
                test_user_conn.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "10000");
                this.loginAs(rootUser);
                if (!((String)root_conn.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) {
                    throw new IllegalStateException("Should be able to set system property");
                }
                this.loginAs(testUser);
                test_user_conn.instanceOperations().removeProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey());
                this.loginAs(rootUser);
                if (!((String)root_conn.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) break;
                throw new IllegalStateException("Should be able remove systemproperty");
            }
            case CREATE_NAMESPACE: {
                String namespace = "__CREATE_NAMESPACE_WITH_PERM_TEST__";
                this.loginAs(testUser);
                test_user_conn.namespaceOperations().create(namespace);
                this.loginAs(rootUser);
                if (root_conn.namespaceOperations().list().contains(namespace)) break;
                throw new IllegalStateException("Should be able to create a namespace");
            }
            case DROP_NAMESPACE: {
                String namespace = "__DROP_NAMESPACE_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_conn.namespaceOperations().create(namespace);
                this.loginAs(testUser);
                test_user_conn.namespaceOperations().delete(namespace);
                this.loginAs(rootUser);
                if (!root_conn.namespaceOperations().list().contains(namespace)) break;
                throw new IllegalStateException("Should be able to delete a namespace");
            }
            case ALTER_NAMESPACE: {
                String namespace = "__ALTER_NAMESPACE_WITH_PERM_TEST__";
                String namespace2 = namespace + "2";
                this.loginAs(rootUser);
                root_conn.namespaceOperations().create(namespace);
                this.loginAs(testUser);
                test_user_conn.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                this.loginAs(rootUser);
                Map<String, String> propies = PermissionsIT.map(root_conn.namespaceOperations().getProperties(namespace));
                if (!propies.get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to set a table property");
                }
                this.loginAs(testUser);
                test_user_conn.namespaceOperations().removeProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey());
                this.loginAs(rootUser);
                propies = PermissionsIT.map(root_conn.namespaceOperations().getProperties(namespace));
                if (propies.get(Property.TABLE_BLOOM_ERRORRATE.getKey()).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to remove a table property");
                }
                this.loginAs(testUser);
                test_user_conn.namespaceOperations().rename(namespace, namespace2);
                this.loginAs(rootUser);
                if (!root_conn.namespaceOperations().list().contains(namespace) && root_conn.namespaceOperations().list().contains(namespace2)) break;
                throw new IllegalStateException("Should be able to rename a table");
            }
            case OBTAIN_DELEGATION_TOKEN: {
                ClientConfiguration clientConf = cluster.getClientConfig();
                if (!clientConf.hasSasl()) break;
                break;
            }
            case GRANT: {
                this.loginAs(rootUser);
                root_conn.securityOperations().grantSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT);
                this.loginAs(testUser);
                test_user_conn.securityOperations().grantSystemPermission(testUser.getPrincipal(), SystemPermission.CREATE_TABLE);
                this.loginAs(rootUser);
                Assert.assertTrue((String)"Test user should have CREATE_TABLE", (boolean)root_conn.securityOperations().hasSystemPermission(testUser.getPrincipal(), SystemPermission.CREATE_TABLE));
                Assert.assertTrue((String)"Test user should have GRANT", (boolean)root_conn.securityOperations().hasSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT));
                root_conn.securityOperations().revokeSystemPermission(testUser.getPrincipal(), SystemPermission.CREATE_TABLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized System Permission: " + perm);
            }
        }
    }

    private void verifyHasOnlyTheseSystemPermissions(Connector root_conn, String user, SystemPermission ... perms) throws AccumuloException, AccumuloSecurityException {
        List<SystemPermission> permList = Arrays.asList(perms);
        for (SystemPermission p : SystemPermission.values()) {
            if (permList.contains(p)) {
                if (root_conn.securityOperations().hasSystemPermission(user, p)) continue;
                throw new IllegalStateException(user + " SHOULD have system permission " + p);
            }
            if (!root_conn.securityOperations().hasSystemPermission(user, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have system permission " + p);
        }
    }

    private void verifyHasNoSystemPermissions(Connector root_conn, String user, SystemPermission ... perms) throws AccumuloException, AccumuloSecurityException {
        for (SystemPermission p : perms) {
            if (!root_conn.securityOperations().hasSystemPermission(user, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have system permission " + p);
        }
    }

    @Test
    public void tablePermissionTest() throws Exception {
        ClusterUser testUser = this.getUser(0);
        ClusterUser rootUser = this.getAdminUser();
        String principal = testUser.getPrincipal();
        AuthenticationToken token = testUser.getToken();
        PasswordToken passwordToken = null;
        if (token instanceof PasswordToken) {
            passwordToken = (PasswordToken)token;
        }
        this.loginAs(rootUser);
        Connector c = this.getConnector();
        c.securityOperations().createLocalUser(principal, passwordToken);
        this.loginAs(testUser);
        Connector test_user_conn = c.getInstance().getConnector(principal, token);
        this.loginAs(rootUser);
        this.verifyHasOnlyTheseTablePermissions(c, c.whoami(), "accumulo.metadata", TablePermission.READ, TablePermission.ALTER_TABLE);
        this.verifyHasOnlyTheseTablePermissions(c, principal, "accumulo.metadata", TablePermission.READ);
        String tableName = this.getUniqueNames(1)[0] + "__TABLE_PERMISSION_TEST__";
        for (TablePermission perm : TablePermission.values()) {
            log.debug("Verifying the " + perm + " permission");
            this.createTestTable(c, principal, tableName);
            this.loginAs(testUser);
            this.testMissingTablePermission(test_user_conn, testUser, perm, tableName);
            this.loginAs(rootUser);
            c.securityOperations().grantTablePermission(principal, tableName, perm);
            this.verifyHasOnlyTheseTablePermissions(c, principal, tableName, perm);
            this.loginAs(testUser);
            this.testGrantedTablePermission(test_user_conn, testUser, perm, tableName);
            this.loginAs(rootUser);
            this.createTestTable(c, principal, tableName);
            c.securityOperations().revokeTablePermission(principal, tableName, perm);
            this.verifyHasNoTablePermissions(c, principal, tableName, perm);
        }
    }

    private void createTestTable(Connector c, String testUser, String tableName) throws Exception, MutationsRejectedException {
        if (!c.tableOperations().exists(tableName)) {
            c.tableOperations().create(tableName);
            BatchWriter writer = c.createBatchWriter(tableName, new BatchWriterConfig());
            Mutation m = new Mutation(new Text("row"));
            m.put(new Text("cf"), new Text("cq"), new Value("val".getBytes()));
            writer.addMutation(m);
            writer.close();
            this.verifyHasOnlyTheseTablePermissions(c, c.whoami(), tableName, TablePermission.values());
            this.verifyHasNoTablePermissions(c, testUser, tableName, TablePermission.values());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testMissingTablePermission(Connector test_user_conn, ClusterUser testUser, TablePermission perm, String tableName) throws Exception {
        log.debug("Confirming that the lack of the " + perm + " permission properly restricts the user");
        switch (perm) {
            case READ: {
                try {
                    Scanner scanner = test_user_conn.createScanner(tableName, Authorizations.EMPTY);
                    int i = 0;
                    for (Map.Entry entry : scanner) {
                        i += 1 + ((Key)entry.getKey()).getRowData().length();
                    }
                    if (i == 0) return;
                    throw new IllegalStateException("Should NOT be able to read from the table");
                }
                catch (RuntimeException e) {
                    AccumuloSecurityException se = (AccumuloSecurityException)e.getCause();
                    if (se.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                    throw se;
                }
            }
            case WRITE: {
                try {
                    BatchWriter writer = test_user_conn.createBatchWriter(tableName, new BatchWriterConfig());
                    Mutation m = new Mutation(new Text("row"));
                    m.put(new Text("a"), new Text("b"), new Value("c".getBytes()));
                    writer.addMutation(m);
                    try {
                        writer.close();
                        throw new IllegalStateException("Should NOT be able to write to a table");
                    }
                    catch (MutationsRejectedException e1) {
                        if (e1.getSecurityErrorCodes().size() <= 0) throw new IllegalStateException("Should NOT be able to write to a table");
                        throw new AccumuloSecurityException(test_user_conn.whoami(), org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode.PERMISSION_DENIED, (Throwable)e1);
                    }
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED) {
                        throw e;
                    }
                    try {
                        test_user_conn.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                        throw new IllegalStateException("Should NOT be able to flsuh a table");
                    }
                    catch (AccumuloSecurityException e2) {
                        if (e2.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                        throw e2;
                    }
                }
            }
            case BULK_IMPORT: {
                return;
            }
            case ALTER_TABLE: {
                HashMap<String, HashSet<Text>> groups = new HashMap<String, HashSet<Text>>();
                groups.put("tgroup", new HashSet<Text>(Arrays.asList(new Text("t1"), new Text("t2"))));
                try {
                    test_user_conn.tableOperations().setLocalityGroups(tableName, groups);
                    throw new IllegalStateException("User should not be able to set locality groups");
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED) {
                        throw e;
                    }
                    try {
                        test_user_conn.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                        throw new IllegalStateException("Should NOT be able to flsuh a table");
                    }
                    catch (AccumuloSecurityException e3) {
                        if (e3.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                        throw e3;
                    }
                }
            }
            case DROP_TABLE: {
                try {
                    test_user_conn.tableOperations().delete(tableName);
                    throw new IllegalStateException("User should not be able delete the table");
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                    throw e;
                }
            }
            case GRANT: {
                try {
                    test_user_conn.securityOperations().grantTablePermission(PermissionsIT.getAdminPrincipal(), tableName, TablePermission.GRANT);
                    throw new IllegalStateException("User should not be able grant permissions");
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                    throw e;
                }
            }
            default: {
                throw new IllegalArgumentException("Unrecognized table Permission: " + perm);
            }
        }
    }

    private void testGrantedTablePermission(Connector test_user_conn, ClusterUser normalUser, TablePermission perm, String tableName) throws AccumuloException, TableExistsException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException {
        log.debug("Confirming that the presence of the " + perm + " permission properly permits the user");
        switch (perm) {
            case READ: {
                Scanner scanner = test_user_conn.createScanner(tableName, Authorizations.EMPTY);
                Iterator iter = scanner.iterator();
                while (iter.hasNext()) {
                    iter.next();
                }
                break;
            }
            case WRITE: {
                test_user_conn.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                BatchWriter writer = test_user_conn.createBatchWriter(tableName, new BatchWriterConfig());
                Mutation m = new Mutation(new Text("row"));
                m.put(new Text("a"), new Text("b"), new Value("c".getBytes()));
                writer.addMutation(m);
                writer.close();
                break;
            }
            case BULK_IMPORT: {
                break;
            }
            case ALTER_TABLE: {
                test_user_conn.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                HashMap<String, HashSet<Text>> groups = new HashMap<String, HashSet<Text>>();
                groups.put("tgroup", new HashSet<Text>(Arrays.asList(new Text("t1"), new Text("t2"))));
                break;
            }
            case DROP_TABLE: {
                test_user_conn.tableOperations().delete(tableName);
                break;
            }
            case GRANT: {
                test_user_conn.securityOperations().grantTablePermission(PermissionsIT.getAdminPrincipal(), tableName, TablePermission.GRANT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized table Permission: " + perm);
            }
        }
    }

    private void verifyHasOnlyTheseTablePermissions(Connector root_conn, String user, String table, TablePermission ... perms) throws AccumuloException, AccumuloSecurityException {
        List<TablePermission> permList = Arrays.asList(perms);
        for (TablePermission p : TablePermission.values()) {
            if (permList.contains(p)) {
                if (root_conn.securityOperations().hasTablePermission(user, table, p)) continue;
                throw new IllegalStateException(user + " SHOULD have table permission " + p + " for table " + table);
            }
            if (!root_conn.securityOperations().hasTablePermission(user, table, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have table permission " + p + " for table " + table);
        }
    }

    private void verifyHasNoTablePermissions(Connector root_conn, String user, String table, TablePermission ... perms) throws AccumuloException, AccumuloSecurityException {
        for (TablePermission p : perms) {
            if (!root_conn.securityOperations().hasTablePermission(user, table, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have table permission " + p + " for table " + table);
        }
    }
}

