/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.AuthsIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanIteratorIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ScanIteratorIT.class);
    private Connector connector;
    private String tableName;
    private String user;
    private boolean saslEnabled;

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Before
    public void setup() throws Exception {
        PasswordToken userToken;
        this.connector = this.getConnector();
        this.tableName = this.getUniqueNames(1)[0];
        this.connector.tableOperations().create(this.tableName);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        ClusterUser clusterUser = this.getUser(0);
        this.user = clusterUser.getPrincipal();
        if (clientConfig.hasSasl()) {
            userToken = null;
            this.saslEnabled = true;
        } else {
            userToken = new PasswordToken((CharSequence)clusterUser.getPassword());
            this.saslEnabled = false;
        }
        if (this.connector.securityOperations().listLocalUsers().contains(this.user)) {
            log.info("Dropping {}", (Object)this.user);
            this.connector.securityOperations().dropLocalUser(this.user);
        }
        this.connector.securityOperations().createLocalUser(this.user, userToken);
        this.connector.securityOperations().grantTablePermission(this.user, this.tableName, TablePermission.READ);
        this.connector.securityOperations().grantTablePermission(this.user, this.tableName, TablePermission.WRITE);
        this.connector.securityOperations().changeUserAuthorizations(this.user, AuthsIterator.AUTHS);
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.user) {
            if (this.saslEnabled) {
                ClusterUser rootUser = this.getAdminUser();
                UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            }
            this.connector.securityOperations().dropLocalUser(this.user);
        }
    }

    @Test
    public void run() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        for (int i = 0; i < 1000; ++i) {
            Mutation m = new Mutation(new Text(String.format("%06d", i)));
            m.put(new Text("cf1"), new Text("cq1"), new Value(Integer.toString(1000 - i).getBytes(StandardCharsets.UTF_8)));
            m.put(new Text("cf1"), new Text("cq2"), new Value(Integer.toString(i - 1000).getBytes(StandardCharsets.UTF_8)));
            bw.addMutation(m);
        }
        bw.close();
        Scanner scanner = c.createScanner(tableName, new Authorizations());
        this.setupIter((ScannerBase)scanner);
        this.verify((Iterable<Map.Entry<Key, Value>>)scanner, 1, 999);
        BatchScanner bscanner = c.createBatchScanner(tableName, new Authorizations(), 3);
        bscanner.setRanges(Collections.singleton(new Range((Key)null, null)));
        this.setupIter((ScannerBase)bscanner);
        this.verify((Iterable<Map.Entry<Key, Value>>)bscanner, 1, 999);
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(new Text(String.format("%06d", 1))));
        ranges.add(new Range(new Text(String.format("%06d", 6)), new Text(String.format("%06d", 16))));
        ranges.add(new Range(new Text(String.format("%06d", 20))));
        ranges.add(new Range(new Text(String.format("%06d", 23))));
        ranges.add(new Range(new Text(String.format("%06d", 56)), new Text(String.format("%06d", 61))));
        ranges.add(new Range(new Text(String.format("%06d", 501)), new Text(String.format("%06d", 504))));
        ranges.add(new Range(new Text(String.format("%06d", 998)), new Text(String.format("%06d", 1000))));
        HashSet<Integer> got = new HashSet<Integer>();
        HashSet<Integer> expected = new HashSet<Integer>();
        for (int i : new int[]{1, 7, 9, 11, 13, 15, 23, 57, 59, 61, 501, 503, 999}) {
            expected.add(i);
        }
        bscanner.setRanges(ranges);
        Object object = bscanner.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            got.add(Integer.parseInt(((Key)entry.getKey()).getRow().toString()));
        }
        System.out.println("got : " + got);
        if (!got.equals(expected)) {
            throw new Exception(got + " != " + expected);
        }
        bscanner.close();
    }

    private void verify(Iterable<Map.Entry<Key, Value>> scanner, int start, int finish) throws Exception {
        int expected = start;
        for (Map.Entry<Key, Value> entry : scanner) {
            if (Integer.parseInt(entry.getKey().getRow().toString()) != expected) {
                throw new Exception("Saw unexpexted " + entry.getKey().getRow() + " " + expected);
            }
            if (!entry.getKey().getColumnQualifier().toString().equals("cq2")) continue;
            expected += 2;
        }
        if (expected != finish + 2) {
            throw new Exception("Ended at " + expected + " not " + (finish + 2));
        }
    }

    private void setupIter(ScannerBase scanner) throws Exception {
        IteratorSetting dropMod = new IteratorSetting(50, "dropMod", "org.apache.accumulo.test.functional.DropModIter");
        dropMod.addOption("mod", "2");
        dropMod.addOption("drop", "0");
        scanner.addScanIterator(dropMod);
    }

    @Test
    public void testAuthsPresentInIteratorEnvironment() throws Exception {
        this.runTest(AuthsIterator.AUTHS, false);
    }

    @Test
    public void testAuthsNotPresentInIteratorEnvironment() throws Exception {
        this.runTest(new Authorizations(new String[]{"B"}), true);
    }

    @Test
    public void testEmptyAuthsInIteratorEnvironment() throws Exception {
        this.runTest(Authorizations.EMPTY, true);
    }

    private void runTest(ScannerBase scanner, Authorizations auths, boolean shouldFail) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        int count = 0;
        for (Map.Entry entry : scanner) {
            Assert.assertEquals((Object)(shouldFail ? "FAIL" : "SUCCESS"), (Object)((Key)entry.getKey()).getRow().toString());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    private void runTest(Authorizations auths, boolean shouldFail) throws Exception {
        ClusterUser clusterUser = this.getUser(0);
        Connector userC = ScanIteratorIT.getCluster().getConnector(clusterUser.getPrincipal(), clusterUser.getToken());
        this.writeTestMutation(userC);
        IteratorSetting setting = new IteratorSetting(10, AuthsIterator.class);
        Scanner scanner = userC.createScanner(this.tableName, auths);
        scanner.addScanIterator(setting);
        BatchScanner batchScanner = userC.createBatchScanner(this.tableName, auths, 1);
        batchScanner.setRanges(Collections.singleton(new Range((CharSequence)"1")));
        batchScanner.addScanIterator(setting);
        this.runTest((ScannerBase)scanner, auths, shouldFail);
        this.runTest((ScannerBase)batchScanner, auths, shouldFail);
        scanner.close();
        batchScanner.close();
    }

    private void writeTestMutation(Connector userC) throws TableNotFoundException, MutationsRejectedException {
        BatchWriter batchWriter = userC.createBatchWriter(this.tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"1");
        m.put(new Text("2"), new Text("3"), new Value("".getBytes()));
        batchWriter.addMutation(m);
        batchWriter.flush();
        batchWriter.close();
    }
}

