/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.util.CheckForMetadataProblems;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.DeleteIT;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(SplitIT.class);
    private String tservMaxMem;
    private String tservMajcDelay;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAXMEM, "5K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "100ms");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void alterConfig() throws Exception {
        Assume.assumeTrue((AccumuloClusterHarness.ClusterType.MINI == SplitIT.getClusterType() ? 1 : 0) != 0);
        InstanceOperations iops = this.getConnector().instanceOperations();
        Map config = iops.getSystemConfiguration();
        this.tservMaxMem = (String)config.get(Property.TSERV_MAXMEM.getKey());
        this.tservMajcDelay = (String)config.get(Property.TSERV_MAJC_DELAY.getKey());
        if (!this.tservMajcDelay.equals("100ms")) {
            iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "100ms");
        }
        boolean restarted = false;
        if (!this.tservMaxMem.equals("5K")) {
            iops.setProperty(Property.TSERV_MAXMEM.getKey(), "5K");
            SplitIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            SplitIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            restarted = true;
        }
        if (!restarted) {
            long millis = AccumuloConfiguration.getTimeInMillis((String)this.tservMajcDelay);
            log.info("Waiting for majc delay period: {}ms", (Object)millis);
            Thread.sleep(millis);
            log.info("Finished waiting for majc delay period");
        }
    }

    @After
    public void resetConfig() throws Exception {
        if (null != this.tservMaxMem) {
            log.info("Resetting {}={}", (Object)Property.TSERV_MAXMEM.getKey(), (Object)this.tservMaxMem);
            this.getConnector().instanceOperations().setProperty(Property.TSERV_MAXMEM.getKey(), this.tservMaxMem);
            this.tservMaxMem = null;
            SplitIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            SplitIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
        if (null != this.tservMajcDelay) {
            log.info("Resetting {}={}", (Object)Property.TSERV_MAJC_DELAY.getKey(), (Object)this.tservMajcDelay);
            this.getConnector().instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.tservMajcDelay);
            this.tservMajcDelay = null;
        }
    }

    @Test
    public void tabletShouldSplit() throws Exception {
        String[] args;
        Connector c = this.getConnector();
        String table = this.getUniqueNames(1)[0];
        c.tableOperations().create(table);
        c.tableOperations().setProperty(table, Property.TABLE_SPLIT_THRESHOLD.getKey(), "256K");
        c.tableOperations().setProperty(table, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "1K");
        TestIngest.Opts opts = new TestIngest.Opts();
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        opts.rows = 100000;
        opts.setTableName(table);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        if (clientConfig.hasSasl()) {
            opts.updateKerberosCredentials(clientConfig);
            vopts.updateKerberosCredentials(clientConfig);
        } else {
            opts.setPrincipal(SplitIT.getAdminPrincipal());
            vopts.setPrincipal(SplitIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        vopts.rows = opts.rows;
        vopts.setTableName(table);
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
        while (c.tableOperations().listSplits(table).size() < 10) {
            UtilWaitThread.sleepUninterruptibly((long)15L, (TimeUnit)TimeUnit.SECONDS);
        }
        String id = (String)c.tableOperations().tableIdMap().get(table);
        Scanner s = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        KeyExtent extent = new KeyExtent(id, null, null);
        s.setRange(extent.toMetadataRange());
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)s);
        int count = 0;
        int shortened = 0;
        for (Map.Entry entry : s) {
            extent = new KeyExtent(((Key)entry.getKey()).getRow(), (Value)entry.getValue());
            if (extent.getEndRow() != null && extent.getEndRow().toString().length() < 14) {
                ++shortened;
            }
            ++count;
        }
        Assert.assertTrue((String)("Shortened should be greater than zero: " + shortened), (shortened > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Count should be cgreater than 10: " + count), (count > 10 ? 1 : 0) != 0);
        if (clientConfig.hasSasl()) {
            ClusterUser rootUser = this.getAdminUser();
            args = new String[]{"-i", cluster.getInstanceName(), "-u", rootUser.getPrincipal(), "--keytab", rootUser.getKeytab().getAbsolutePath(), "-z", cluster.getZooKeepers()};
        } else {
            PasswordToken token = (PasswordToken)SplitIT.getAdminToken();
            args = new String[]{"-i", cluster.getInstanceName(), "-u", "root", "-p", new String(token.getPassword(), StandardCharsets.UTF_8), "-z", cluster.getZooKeepers()};
        }
        Assert.assertEquals((long)0L, (long)SplitIT.getCluster().getClusterControl().exec(CheckForMetadataProblems.class, args));
    }

    @Test
    public void interleaveSplit() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
        c.tableOperations().setProperty(tableName, Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none");
        UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
        ReadWriteIT.interleaveTest(c, tableName);
        UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
        int numSplits = c.tableOperations().listSplits(tableName).size();
        while (numSplits <= 20) {
            log.info("Waiting for splits to happen");
            Thread.sleep(2000L);
            numSplits = c.tableOperations().listSplits(tableName).size();
        }
        Assert.assertTrue((String)("Expected at least 20 splits, saw " + numSplits), (numSplits > 20 ? 1 : 0) != 0);
    }

    @Test
    public void deleteSplit() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
        ClientConfiguration clientConfig = SplitIT.getCluster().getClientConfig();
        String password = null;
        String keytab = null;
        if (clientConfig.hasSasl()) {
            keytab = this.getAdminUser().getKeytab().getAbsolutePath();
        } else {
            password = new String(((PasswordToken)SplitIT.getAdminToken()).getPassword(), StandardCharsets.UTF_8);
        }
        DeleteIT.deleteTest(c, SplitIT.getCluster(), SplitIT.getAdminPrincipal(), password, tableName, keytab);
        c.tableOperations().flush(tableName, null, null, true);
        for (int i = 0; i < 5; ++i) {
            UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            if (c.tableOperations().listSplits(tableName).size() > 20) break;
        }
        Assert.assertTrue((c.tableOperations().listSplits(tableName).size() > 20 ? 1 : 0) != 0);
    }
}

