/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mrit;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationTestMapReduce
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(IntegrationTestMapReduce.class);
    private static boolean isMapReduce = false;

    public static boolean isMapReduce() {
        return isMapReduce;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Wrong number of args: <input> <output>");
            return 1;
        }
        Configuration conf = this.getConf();
        Job job = Job.getInstance((Configuration)conf, (String)"accumulo integration test runner");
        conf = job.getConfiguration();
        conf.setLong("mapreduce.task.timeout", 1200000L);
        conf.setInt("mapreduce.map.memory.mb", 4000);
        conf.setBoolean("mapreduce.job.user.classpath.first", true);
        job.setSpeculativeExecution(false);
        job.setInputFormatClass(NLineInputFormat.class);
        NLineInputFormat.setNumLinesPerSplit((Job)job, (int)1);
        job.setJarByClass(IntegrationTestMapReduce.class);
        job.setMapperClass(TestMapper.class);
        job.setReducerClass(TestReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(args[0]));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new IntegrationTestMapReduce(), (String[])args));
    }

    public static class TestReducer
    extends Reducer<Text, Text, Text, Text> {
        protected void reduce(Text code, Iterable<Text> tests, Reducer.Context context) throws IOException, InterruptedException {
            StringBuilder result = new StringBuilder("\n");
            for (Text test : tests) {
                result.append("   ");
                result.append(test.toString());
                result.append("\n");
            }
            context.write((Object)code, (Object)new Text(result.toString()));
        }
    }

    public static class TestMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        static final Text FAIL = new Text("FAIL");
        static final Text PASS = new Text("PASS");
        static final Text ERROR = new Text("ERROR");

        protected void map(LongWritable key, Text value, final Mapper.Context context) throws IOException, InterruptedException {
            isMapReduce = true;
            String className = value.toString();
            if (className.trim().isEmpty()) {
                return;
            }
            final ArrayList failures = new ArrayList();
            Class<?> test = null;
            try {
                test = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.debug("Error finding class {}", (Object)className, (Object)e);
                context.getCounter((Enum)TestCounts.ERROR).increment(1L);
                context.write((Object)ERROR, (Object)new Text(e.toString()));
                return;
            }
            log.info("Running test {}", (Object)className);
            JUnitCore core = new JUnitCore();
            core.addListener(new RunListener(){

                public void testStarted(Description description) throws Exception {
                    log.info("Starting {}", (Object)description);
                    context.progress();
                }

                public void testFinished(Description description) throws Exception {
                    log.info("Finished {}", (Object)description);
                    context.progress();
                }

                public void testFailure(Failure failure) throws Exception {
                    log.info("Test failed: {}", (Object)failure.getDescription(), (Object)failure.getException());
                    failures.add(failure.getDescription().getMethodName());
                    context.progress();
                }
            });
            context.setStatus(test.getSimpleName());
            try {
                Result result = core.run(new Class[]{test});
                if (result.wasSuccessful()) {
                    log.info("{} was successful", (Object)className);
                    context.getCounter((Enum)TestCounts.PASS).increment(1L);
                    context.write((Object)PASS, (Object)value);
                } else {
                    log.info("{} failed", (Object)className);
                    context.getCounter((Enum)TestCounts.FAIL).increment(1L);
                    context.write((Object)FAIL, (Object)new Text(className + "(" + StringUtils.join(failures, (String)", ") + ")"));
                }
            }
            catch (Exception e) {
                log.info("Test failed: {}", (Object)className, (Object)e);
            }
        }

        public static enum TestCounts {
            PASS,
            FAIL,
            ERROR;

        }
    }
}

