/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.proxy;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.proxy.thrift.NamespacePermission;
import org.apache.accumulo.proxy.thrift.SystemPermission;
import org.apache.accumulo.proxy.thrift.TablePermission;
import org.apache.accumulo.proxy.thrift.TimeType;
import org.apache.accumulo.test.proxy.TestProxyClient;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestProxySecurityOperations {
    protected static TServer proxy;
    protected static TestProxyClient tpc;
    protected static ByteBuffer userpass;
    protected static final int port = 10196;
    protected static final String testtable = "testtable";
    protected static final String testuser = "VonJines";
    protected static final String testnamespace = "testns";
    protected static final ByteBuffer testpw;

    @BeforeClass
    public static void setup() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("useMockInstance", "true");
        prop.put("tokenClass", PasswordToken.class.getName());
        proxy = Proxy.createProxyServer((HostAndPort)HostAndPort.fromParts((String)"localhost", (int)10196), (TProtocolFactory)new TCompactProtocol.Factory(), (Properties)prop).server;
        while (!proxy.isServing()) {
            Thread.sleep(500L);
        }
        tpc = new TestProxyClient("localhost", 10196);
        userpass = tpc.proxy().login("root", Collections.singletonMap("password", ""));
    }

    @AfterClass
    public static void tearDown() throws InterruptedException {
        proxy.stop();
    }

    @Before
    public void makeTestTableAndUser() throws Exception {
        tpc.proxy().createTable(userpass, testtable, true, TimeType.MILLIS);
        tpc.proxy().createLocalUser(userpass, testuser, testpw);
        tpc.proxy().createNamespace(userpass, testnamespace);
    }

    @After
    public void deleteTestTable() throws Exception {
        tpc.proxy().deleteTable(userpass, testtable);
        tpc.proxy().dropLocalUser(userpass, testuser);
        tpc.proxy().deleteNamespace(userpass, testnamespace);
    }

    @Test
    public void create() throws TException {
        tpc.proxy().createLocalUser(userpass, "VonJines2", testpw);
        Assert.assertTrue((boolean)tpc.proxy().listLocalUsers(userpass).contains("VonJines2"));
        tpc.proxy().dropLocalUser(userpass, "VonJines2");
        Assert.assertTrue((!tpc.proxy().listLocalUsers(userpass).contains("VonJines2") ? 1 : 0) != 0);
    }

    @Test
    public void authenticate() throws TException {
        Assert.assertTrue((boolean)tpc.proxy().authenticateUser(userpass, testuser, this.bb2pp(testpw)));
        Assert.assertFalse((boolean)tpc.proxy().authenticateUser(userpass, "EvilUser", this.bb2pp(testpw)));
        tpc.proxy().changeLocalUserPassword(userpass, testuser, ByteBuffer.wrap("newpass".getBytes()));
        Assert.assertFalse((boolean)tpc.proxy().authenticateUser(userpass, testuser, this.bb2pp(testpw)));
        Assert.assertTrue((boolean)tpc.proxy().authenticateUser(userpass, testuser, this.bb2pp(ByteBuffer.wrap("newpass".getBytes()))));
    }

    @Test
    public void tablePermissions() throws TException {
        tpc.proxy().grantTablePermission(userpass, testuser, testtable, TablePermission.ALTER_TABLE);
        Assert.assertTrue((boolean)tpc.proxy().hasTablePermission(userpass, testuser, testtable, TablePermission.ALTER_TABLE));
        tpc.proxy().revokeTablePermission(userpass, testuser, testtable, TablePermission.ALTER_TABLE);
        Assert.assertFalse((boolean)tpc.proxy().hasTablePermission(userpass, testuser, testtable, TablePermission.ALTER_TABLE));
    }

    @Test
    public void systemPermissions() throws TException {
        tpc.proxy().grantSystemPermission(userpass, testuser, SystemPermission.ALTER_USER);
        Assert.assertTrue((boolean)tpc.proxy().hasSystemPermission(userpass, testuser, SystemPermission.ALTER_USER));
        tpc.proxy().revokeSystemPermission(userpass, testuser, SystemPermission.ALTER_USER);
        Assert.assertFalse((boolean)tpc.proxy().hasSystemPermission(userpass, testuser, SystemPermission.ALTER_USER));
    }

    @Test
    public void auths() throws TException {
        HashSet<ByteBuffer> newauths = new HashSet<ByteBuffer>();
        newauths.add(ByteBuffer.wrap("BBR".getBytes()));
        newauths.add(ByteBuffer.wrap("Barney".getBytes()));
        tpc.proxy().changeUserAuthorizations(userpass, testuser, newauths);
        List actualauths = tpc.proxy().getUserAuthorizations(userpass, testuser);
        Assert.assertEquals((long)actualauths.size(), (long)newauths.size());
        for (ByteBuffer auth : actualauths) {
            Assert.assertTrue((boolean)newauths.contains(auth));
        }
    }

    @Test
    public void namespacePermissions() throws TException {
        tpc.proxy().grantNamespacePermission(userpass, testuser, testnamespace, NamespacePermission.ALTER_NAMESPACE);
        Assert.assertTrue((boolean)tpc.proxy().hasNamespacePermission(userpass, testuser, testnamespace, NamespacePermission.ALTER_NAMESPACE));
        tpc.proxy().revokeNamespacePermission(userpass, testuser, testnamespace, NamespacePermission.ALTER_NAMESPACE);
        Assert.assertFalse((boolean)tpc.proxy().hasNamespacePermission(userpass, testuser, testnamespace, NamespacePermission.ALTER_NAMESPACE));
    }

    private Map<String, String> bb2pp(ByteBuffer cf) {
        TreeMap<String, String> toRet = new TreeMap<String, String>();
        toRet.put("password", ByteBufferUtil.toString((ByteBuffer)cf));
        return toRet;
    }

    static {
        testpw = ByteBuffer.wrap("fiveones".getBytes());
    }
}

