/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Properties;
import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.commons.math3.random.RandomDataGenerator;

public class Config
extends Test {
    private static final String LAST_SETTING = "lastSetting";
    private static final String LAST_TABLE_SETTING = "lastTableSetting";
    private static final String LAST_NAMESPACE_SETTING = "lastNamespaceSetting";
    Setting[] settings = new Setting[]{Config.s(Property.TSERV_BLOOM_LOAD_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_BULK_PROCESS_THREADS, 1L, 10L), Config.s(Property.TSERV_BULK_RETRY, 1L, 10L), Config.s(Property.TSERV_BULK_TIMEOUT, 10L, 600L), Config.s(Property.TSERV_BULK_ASSIGNMENT_THREADS, 1L, 10L), Config.s(Property.TSERV_DATACACHE_SIZE, 0L, 1000000000L), Config.s(Property.TSERV_INDEXCACHE_SIZE, 0L, 1000000000L), Config.s(Property.TSERV_CLIENT_TIMEOUT, 100L, 10000L), Config.s(Property.TSERV_MAJC_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_MAJC_DELAY, 100L, 10000L), Config.s(Property.TSERV_MAJC_THREAD_MAXOPEN, 3L, 100L), Config.s(Property.TSERV_MINC_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_DEFAULT_BLOCKSIZE, 100000L, 10000000L), Config.s(Property.TSERV_MAX_IDLE, 10000L, 500000L), Config.s(Property.TSERV_MAXMEM, 1000000L, 0xC0000000L), Config.s(Property.TSERV_READ_AHEAD_MAXCONCURRENT, 1L, 25L), Config.s(Property.TSERV_MIGRATE_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX, 10000L, 0x100000L), Config.s(Property.TSERV_RECOVERY_MAX_CONCURRENT, 1L, 100L), Config.s(Property.TSERV_SCAN_MAX_OPENFILES, 10L, 1000L), Config.s(Property.TSERV_THREADCHECK, 100L, 10000L), Config.s(Property.TSERV_MINTHREADS, 1L, 100L), Config.s(Property.TSERV_SESSION_MAXIDLE, 100L, 300000L), Config.s(Property.TSERV_SORT_BUFFER_SIZE, 0x100000L, 0x40000000L), Config.s(Property.TSERV_TABLET_SPLIT_FINDMIDPOINT_MAXOPEN, 5L, 100L), Config.s(Property.TSERV_WAL_BLOCKSIZE, 0x100000L, 0x280000000L), Config.s(Property.TSERV_WORKQ_THREADS, 1L, 10L), Config.s(Property.MASTER_BULK_THREADPOOL_SIZE, 1L, 10L), Config.s(Property.MASTER_BULK_RETRIES, 1L, 10L), Config.s(Property.MASTER_BULK_TIMEOUT, 10L, 600L), Config.s(Property.MASTER_FATE_THREADPOOL_SIZE, 1L, 100L), Config.s(Property.MASTER_RECOVERY_DELAY, 0L, 100L), Config.s(Property.MASTER_LEASE_RECOVERY_WAITING_PERIOD, 0L, 10L), Config.s(Property.MASTER_RECOVERY_MAXTIME, 10L, 1000L), Config.s(Property.MASTER_THREADCHECK, 100L, 10000L), Config.s(Property.MASTER_MINTHREADS, 1L, 200L)};
    Setting[] tableSettings = new Setting[]{Config.s(Property.TABLE_MAJC_RATIO, 1L, 10L), Config.s(Property.TABLE_MAJC_COMPACTALL_IDLETIME, 100L, 36000000L), Config.s(Property.TABLE_SPLIT_THRESHOLD, 10240L, 0x280000000L), Config.s(Property.TABLE_MINC_COMPACT_IDLETIME, 100L, 360000000L), Config.s(Property.TABLE_SCAN_MAXMEM, 10240L, 0xA00000L), Config.s(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, 10240L, 0xA00000L), Config.s(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, 10240L, 0xA00000L), Config.s(Property.TABLE_FILE_REPLICATION, 0L, 5L), Config.s(Property.TABLE_FILE_MAX, 2L, 50L)};

    static Setting s(Property property, long min, long max) {
        return new Setting(property, min, max);
    }

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Property property;
        int choice;
        Object lastSetting = state.getOkIfAbsent(LAST_SETTING);
        if (lastSetting != null) {
            int choice2 = Integer.parseInt(lastSetting.toString());
            Property property2 = this.settings[choice2].property;
            this.log.debug((Object)("Setting " + property2.getKey() + " back to " + property2.getDefaultValue()));
            env.getConnector().instanceOperations().setProperty(property2.getKey(), property2.getDefaultValue());
        }
        if ((lastSetting = state.getOkIfAbsent(LAST_TABLE_SETTING)) != null) {
            String[] parts = lastSetting.toString().split(",");
            String table = parts[0];
            choice = Integer.parseInt(parts[1]);
            property = this.tableSettings[choice].property;
            if (env.getConnector().tableOperations().exists(table)) {
                this.log.debug((Object)("Setting " + property.getKey() + " on " + table + " back to " + property.getDefaultValue()));
                try {
                    env.getConnector().tableOperations().setProperty(table, property.getKey(), property.getDefaultValue());
                }
                catch (AccumuloException ex) {
                    if (ex.getCause() instanceof ThriftTableOperationException) {
                        ThriftTableOperationException ttoe = (ThriftTableOperationException)ex.getCause();
                        if (ttoe.type == TableOperationExceptionType.NOTFOUND) {
                            return;
                        }
                    }
                    throw ex;
                }
            }
        }
        if ((lastSetting = state.getOkIfAbsent(LAST_NAMESPACE_SETTING)) != null) {
            String[] parts = lastSetting.toString().split(",");
            String namespace = parts[0];
            choice = Integer.parseInt(parts[1]);
            property = this.tableSettings[choice].property;
            if (env.getConnector().namespaceOperations().exists(namespace)) {
                this.log.debug((Object)("Setting " + property.getKey() + " on " + namespace + " back to " + property.getDefaultValue()));
                try {
                    env.getConnector().namespaceOperations().setProperty(namespace, property.getKey(), property.getDefaultValue());
                }
                catch (AccumuloException ex) {
                    if (ex.getCause() instanceof ThriftTableOperationException) {
                        ThriftTableOperationException ttoe = (ThriftTableOperationException)ex.getCause();
                        if (ttoe.type == TableOperationExceptionType.NAMESPACE_NOTFOUND) {
                            return;
                        }
                    }
                    throw ex;
                }
            }
        }
        state.remove(LAST_SETTING);
        state.remove(LAST_TABLE_SETTING);
        state.remove(LAST_NAMESPACE_SETTING);
        RandomDataGenerator random = new RandomDataGenerator();
        int dice = random.nextInt(0, 2);
        if (dice == 0) {
            this.changeTableSetting(random, state, env, props);
        } else if (dice == 1) {
            this.changeNamespaceSetting(random, state, env, props);
        } else {
            this.changeSetting(random, state, env, props);
        }
    }

    private void changeTableSetting(RandomDataGenerator random, State state, Environment env, Properties props) throws Exception {
        int choice = random.nextInt(0, this.tableSettings.length - 1);
        Setting setting = this.tableSettings[choice];
        SortedSet<String> tables = env.getConnector().tableOperations().list().tailSet("ctt").headSet("ctu");
        if (tables.isEmpty()) {
            return;
        }
        String table = random.nextSample(tables, 1)[0].toString();
        long newValue = random.nextLong(setting.min, setting.max);
        state.set(LAST_TABLE_SETTING, table + "," + choice);
        this.log.debug((Object)("Setting " + setting.property.getKey() + " on table " + table + " to " + newValue));
        try {
            env.getConnector().tableOperations().setProperty(table, setting.property.getKey(), "" + newValue);
        }
        catch (AccumuloException ex) {
            if (ex.getCause() instanceof ThriftTableOperationException) {
                ThriftTableOperationException ttoe = (ThriftTableOperationException)ex.getCause();
                if (ttoe.type == TableOperationExceptionType.NOTFOUND) {
                    return;
                }
            }
            throw ex;
        }
    }

    private void changeNamespaceSetting(RandomDataGenerator random, State state, Environment env, Properties props) throws Exception {
        int choice = random.nextInt(0, this.tableSettings.length - 1);
        Setting setting = this.tableSettings[choice];
        SortedSet<String> namespaces = env.getConnector().namespaceOperations().list().tailSet("nspc").headSet("nspd");
        if (namespaces.isEmpty()) {
            return;
        }
        String namespace = random.nextSample(namespaces, 1)[0].toString();
        long newValue = random.nextLong(setting.min, setting.max);
        state.set(LAST_NAMESPACE_SETTING, namespace + "," + choice);
        this.log.debug((Object)("Setting " + setting.property.getKey() + " on namespace " + namespace + " to " + newValue));
        try {
            env.getConnector().namespaceOperations().setProperty(namespace, setting.property.getKey(), "" + newValue);
        }
        catch (AccumuloException ex) {
            if (ex.getCause() instanceof ThriftTableOperationException) {
                ThriftTableOperationException ttoe = (ThriftTableOperationException)ex.getCause();
                if (ttoe.type == TableOperationExceptionType.NAMESPACE_NOTFOUND) {
                    return;
                }
            }
            throw ex;
        }
    }

    private void changeSetting(RandomDataGenerator random, State state, Environment env, Properties props) throws Exception {
        int choice = random.nextInt(0, this.settings.length - 1);
        Setting setting = this.settings[choice];
        long newValue = random.nextLong(setting.min, setting.max);
        state.set(LAST_SETTING, "" + choice);
        this.log.debug((Object)("Setting " + setting.property.getKey() + " to " + newValue));
        env.getConnector().instanceOperations().setProperty(setting.property.getKey(), "" + newValue);
    }

    static class Setting {
        public Property property;
        public long min;
        public long max;

        public Setting(Property property, long min, long max) {
            this.property = property;
            this.min = min;
            this.max = max;
        }
    }
}

