/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class RenameTable
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String srcTableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        String newTableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        String srcNamespace = "";
        String newNamespace = "";
        int index = srcTableName.indexOf(46);
        if (-1 != index) {
            srcNamespace = srcTableName.substring(0, index);
        }
        if (-1 != (index = newTableName.indexOf(46))) {
            newNamespace = newTableName.substring(0, index);
        }
        try {
            conn.tableOperations().rename(srcTableName, newTableName);
            this.log.debug((Object)("Renamed table " + srcTableName + " " + newTableName));
        }
        catch (TableExistsException e) {
            this.log.debug((Object)("Rename " + srcTableName + " failed, " + newTableName + " exists"));
        }
        catch (TableNotFoundException e) {
            Throwable cause = e.getCause();
            if (null != cause && cause.getClass().isAssignableFrom(NamespaceNotFoundException.class)) {
                this.log.debug((Object)("Rename failed because new namespace doesn't exist: " + newNamespace), cause);
                return;
            }
            this.log.debug((Object)("Rename " + srcTableName + " failed, doesnt exist"));
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Rename: " + e.toString()));
        }
        catch (AccumuloException e) {
            if (!srcNamespace.equals(newNamespace)) {
                return;
            }
            this.log.debug((Object)("Rename " + srcTableName + " failed."), (Throwable)e);
        }
        if (!srcNamespace.equals(newNamespace)) {
            this.log.error((Object)"RenameTable operation should have failed when renaming across namespaces.");
        }
    }
}

