/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class Setup
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        int i;
        Random rand = new Random();
        state.set("rand", rand);
        int numTables = Integer.parseInt(props.getProperty("numTables", "9"));
        int numNamespaces = Integer.parseInt(props.getProperty("numNamespaces", "2"));
        this.log.debug((Object)("numTables = " + numTables));
        this.log.debug((Object)("numNamespaces = " + numNamespaces));
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> namespaces = new ArrayList<String>();
        for (int i2 = 0; i2 < numNamespaces; ++i2) {
            namespaces.add(String.format("nspc_%03d", i2));
        }
        double tableCeil = Math.ceil((double)numTables / (double)(numNamespaces + 1));
        int i3 = 0;
        while ((double)i3 < tableCeil) {
            tables.add(String.format("ctt_%03d", i3));
            ++i3;
        }
        double tableFloor = Math.floor(numTables / (numNamespaces + 1));
        for (String n : namespaces) {
            i = 0;
            while ((double)i < tableFloor) {
                tables.add(String.format(n + ".ctt_%03d", i));
                ++i;
            }
        }
        state.set("tables", tables);
        state.set("namespaces", namespaces);
        int numUsers = Integer.parseInt(props.getProperty("numUsers", "5"));
        this.log.debug((Object)("numUsers = " + numUsers));
        ArrayList<String> users = new ArrayList<String>();
        for (i = 0; i < numUsers; ++i) {
            users.add(String.format("user%03d", i));
        }
        state.set("users", users);
    }
}

