/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;

public class ExportIndex
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String indexTableName = (String)state.get("indexTableName");
        String tmpIndexTableName = indexTableName + "_tmp";
        String exportDir = "/tmp/shard_export/" + indexTableName;
        String copyDir = "/tmp/shard_export/" + tmpIndexTableName;
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        fs.delete(new Path("/tmp/shard_export/" + indexTableName), true);
        fs.delete(new Path("/tmp/shard_export/" + tmpIndexTableName), true);
        env.getConnector().tableOperations().setProperty(indexTableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "20G");
        long t1 = System.currentTimeMillis();
        env.getConnector().tableOperations().flush(indexTableName, null, null, true);
        env.getConnector().tableOperations().offline(indexTableName);
        long t2 = System.currentTimeMillis();
        env.getConnector().tableOperations().exportTable(indexTableName, exportDir);
        long t3 = System.currentTimeMillis();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(exportDir, "distcp.txt")), StandardCharsets.UTF_8));
        String file = null;
        while ((file = reader.readLine()) != null) {
            Path src = new Path(file);
            Path dest = new Path(new Path(copyDir), src.getName());
            FileUtil.copy((FileSystem)fs, (Path)src, (FileSystem)fs, (Path)dest, (boolean)false, (boolean)true, (Configuration)CachedConfiguration.getInstance());
        }
        reader.close();
        long t4 = System.currentTimeMillis();
        env.getConnector().tableOperations().online(indexTableName);
        env.getConnector().tableOperations().importTable(tmpIndexTableName, copyDir);
        long t5 = System.currentTimeMillis();
        fs.delete(new Path(exportDir), true);
        fs.delete(new Path(copyDir), true);
        HashSet splits1 = new HashSet(env.getConnector().tableOperations().listSplits(indexTableName));
        HashSet splits2 = new HashSet(env.getConnector().tableOperations().listSplits(tmpIndexTableName));
        if (!splits1.equals(splits2)) {
            throw new Exception("Splits not equals " + indexTableName + " " + tmpIndexTableName);
        }
        HashMap<String, String> props1 = new HashMap<String, String>();
        for (Map.Entry entry : env.getConnector().tableOperations().getProperties(indexTableName)) {
            props1.put((String)entry.getKey(), (String)entry.getValue());
        }
        HashMap<String, String> props2 = new HashMap<String, String>();
        for (Map.Entry entry : env.getConnector().tableOperations().getProperties(tmpIndexTableName)) {
            props2.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (!props1.equals(props2)) {
            throw new Exception("Props not equals " + indexTableName + " " + tmpIndexTableName);
        }
        env.getConnector().tableOperations().removeProperty(indexTableName, Property.TABLE_SPLIT_THRESHOLD.getKey());
        env.getConnector().tableOperations().removeProperty(tmpIndexTableName, Property.TABLE_SPLIT_THRESHOLD.getKey());
        this.log.debug((Object)("Imported " + tmpIndexTableName + " from " + indexTableName + " flush: " + (t2 - t1) + "ms export: " + (t3 - t2) + "ms copy:" + (t4 - t3) + "ms import:" + (t5 - t4) + "ms"));
    }
}

