/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class VerifyIndex
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String indexTableName = (String)state.get("indexTableName");
        String tmpIndexTableName = indexTableName + "_tmp";
        Scanner indexScanner1 = env.getConnector().createScanner(tmpIndexTableName, Authorizations.EMPTY);
        Scanner indexScanner2 = env.getConnector().createScanner(indexTableName, Authorizations.EMPTY);
        Iterator iter = indexScanner2.iterator();
        int count = 0;
        for (Map.Entry entry : indexScanner1) {
            Key key2;
            if (!iter.hasNext()) {
                throw new Exception("index rebuild mismatch " + entry.getKey() + " " + indexTableName);
            }
            Key key1 = (Key)entry.getKey();
            if (!key1.equals(key2 = (Key)((Map.Entry)iter.next()).getKey(), PartialKey.ROW_COLFAM_COLQUAL)) {
                throw new Exception("index rebuild mismatch " + key1 + " " + key2 + " " + indexTableName + " " + tmpIndexTableName);
            }
            if (++count % 1000 != 0) continue;
            this.makingProgress();
        }
        if (iter.hasNext()) {
            throw new Exception("index rebuild mismatch " + ((Map.Entry)iter.next()).getKey() + " " + tmpIndexTableName);
        }
        this.log.debug((Object)("Verified " + count + " index entries "));
        env.getConnector().tableOperations().delete(indexTableName);
        env.getConnector().tableOperations().rename(tmpIndexTableName, indexTableName);
    }
}

