/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.master.replication.RemoveCompleteReplicationRecords;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class RemoveCompleteReplicationRecordsIT
extends ConfigurableMacBase {
    private MockRemoveCompleteReplicationRecords rcrr;
    private Connector conn;

    @Before
    public void initialize() throws Exception {
        this.conn = this.getConnector();
        this.rcrr = new MockRemoveCompleteReplicationRecords(this.conn);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.READ);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
        ReplicationTable.setOnline((Connector)this.conn);
    }

    @Test
    public void notYetReplicationRecordsIgnored() throws Exception {
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        int numRecords = 3;
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (String)Integer.toString(i), (Value)StatusUtil.openWithUnknownLengthValue());
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)numRecords, (long)Iterables.size((Iterable)ReplicationTable.getScanner((Connector)this.conn)));
        BatchScanner bs = ReplicationTable.getBatchScanner((Connector)this.conn, (int)1);
        bs.setRanges(Collections.singleton(new Range()));
        IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
        bs.addScanIterator(cfg);
        bw = (BatchWriter)EasyMock.createMock(BatchWriter.class);
        EasyMock.replay((Object[])new Object[]{bw});
        this.rcrr.removeCompleteRecords(this.conn, bs, bw);
        bs.close();
        Assert.assertEquals((long)numRecords, (long)Iterables.size((Iterable)ReplicationTable.getScanner((Connector)this.conn)));
    }

    @Test
    public void partiallyReplicatedRecordsIgnored() throws Exception {
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (String)Integer.toString(i), (Value)ProtobufUtil.toValue((GeneratedMessage)builder.setBegin((long)(1000 * (i + 1))).build()));
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)numRecords, (long)Iterables.size((Iterable)ReplicationTable.getScanner((Connector)this.conn)));
        BatchScanner bs = ReplicationTable.getBatchScanner((Connector)this.conn, (int)1);
        bs.setRanges(Collections.singleton(new Range()));
        IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
        bs.addScanIterator(cfg);
        bw = (BatchWriter)EasyMock.createMock(BatchWriter.class);
        EasyMock.replay((Object[])new Object[]{bw});
        this.rcrr.removeCompleteRecords(this.conn, bs, bw);
        bs.close();
        Assert.assertEquals((long)numRecords, (long)Iterables.size((Iterable)ReplicationTable.getScanner((Connector)this.conn)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replicatedClosedWorkRecordsAreNotRemovedWithoutClosedStatusRecords() throws Exception {
        BatchWriter replBw = ReplicationTable.getBatchWriter((Connector)this.conn);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (String)Integer.toString(i), (Value)ProtobufUtil.toValue((GeneratedMessage)builder.setBegin((long)(1000 * (i + 1))).build()));
            replBw.addMutation(m);
        }
        String fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        Mutation m = new Mutation((CharSequence)fileToRemove);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)"5", (Value)ProtobufUtil.toValue((GeneratedMessage)builder.setBegin(10000L).setEnd(10000L).setClosed(false).build()));
        replBw.addMutation(m);
        ++numRecords;
        fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        m = new Mutation((CharSequence)fileToRemove);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)"6", (Value)ProtobufUtil.toValue((GeneratedMessage)builder.setBegin(10000L).setEnd(10000L).setClosed(false).build()));
        replBw.addMutation(m);
        replBw.flush();
        Assert.assertEquals((long)(++numRecords), (long)Iterables.size((Iterable)ReplicationTable.getScanner((Connector)this.conn)));
        BatchScanner bs = ReplicationTable.getBatchScanner((Connector)this.conn, (int)1);
        bs.setRanges(Collections.singleton(new Range()));
        IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
        bs.addScanIterator(cfg);
        try {
            Assert.assertEquals((long)0L, (long)this.rcrr.removeCompleteRecords(this.conn, bs, replBw));
        }
        finally {
            bs.close();
            replBw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replicatedClosedRowsAreRemoved() throws Exception {
        BatchWriter replBw = ReplicationTable.getBatchWriter((Connector)this.conn);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        long time = System.currentTimeMillis();
        for (int i = 0; i < numRecords; ++i) {
            builder.setCreatedTime(time++);
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            Value v = ProtobufUtil.toValue((GeneratedMessage)builder.setBegin((long)(1000 * (i + 1))).build());
            ReplicationSchema.StatusSection.add((Mutation)m, (String)Integer.toString(i), (Value)v);
            replBw.addMutation(m);
            m = ReplicationSchema.OrderSection.createMutation((String)file, (long)time);
            ReplicationSchema.OrderSection.add((Mutation)m, (String)Integer.toString(i), (Value)v);
            replBw.addMutation(m);
        }
        HashSet<String> filesToRemove = new HashSet<String>();
        int finalNumRecords = numRecords *= 2;
        String fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        filesToRemove.add(fileToRemove);
        Mutation m = new Mutation((CharSequence)fileToRemove);
        ReplicationTarget target = new ReplicationTarget("peer1", "5", "5");
        Value value = ProtobufUtil.toValue((GeneratedMessage)builder.setBegin(10000L).setEnd(10000L).setClosed(true).setCreatedTime(time).build());
        ReplicationSchema.StatusSection.add((Mutation)m, (String)"5", (Value)value);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        replBw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)fileToRemove, (long)time);
        ReplicationSchema.OrderSection.add((Mutation)m, (String)"5", (Value)value);
        replBw.addMutation(m);
        ++time;
        numRecords += 3;
        fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        filesToRemove.add(fileToRemove);
        m = new Mutation((CharSequence)fileToRemove);
        value = ProtobufUtil.toValue((GeneratedMessage)builder.setBegin(10000L).setEnd(10000L).setClosed(true).setCreatedTime(time).build());
        target = new ReplicationTarget("peer1", "6", "6");
        ReplicationSchema.StatusSection.add((Mutation)m, (String)"6", (Value)value);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        replBw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)fileToRemove, (long)time);
        ReplicationSchema.OrderSection.add((Mutation)m, (String)"6", (Value)value);
        replBw.addMutation(m);
        ++time;
        replBw.flush();
        Assert.assertEquals((long)(numRecords += 3), (long)Iterables.size((Iterable)ReplicationTable.getScanner((Connector)this.conn)));
        BatchScanner bs = ReplicationTable.getBatchScanner((Connector)this.conn, (int)1);
        bs.setRanges(Collections.singleton(new Range()));
        ReplicationSchema.StatusSection.limit((ScannerBase)bs);
        ReplicationSchema.WorkSection.limit((ScannerBase)bs);
        IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
        bs.addScanIterator(cfg);
        try {
            Assert.assertEquals((long)4L, (long)this.rcrr.removeCompleteRecords(this.conn, bs, replBw));
        }
        finally {
            bs.close();
            replBw.close();
        }
        int actualRecords = 0;
        try (Scanner s = ReplicationTable.getScanner((Connector)this.conn);){
            for (Map.Entry entry : s) {
                Assert.assertFalse((boolean)filesToRemove.contains(((Key)entry.getKey()).getRow().toString()));
                ++actualRecords;
            }
        }
        Assert.assertEquals((long)finalNumRecords, (long)actualRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void partiallyReplicatedEntriesPrecludeRowDeletion() throws Exception {
        BatchWriter replBw = ReplicationTable.getBatchWriter((Connector)this.conn);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (String)Integer.toString(i), (Value)ProtobufUtil.toValue((GeneratedMessage)builder.setBegin((long)(1000 * (i + 1))).build()));
            replBw.addMutation(m);
        }
        String fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        Mutation m = new Mutation((CharSequence)fileToRemove);
        ReplicationTarget target = new ReplicationTarget("peer1", "5", "5");
        Value value = ProtobufUtil.toValue((GeneratedMessage)builder.setBegin(10000L).setEnd(10000L).setClosed(true).build());
        ReplicationSchema.StatusSection.add((Mutation)m, (String)"5", (Value)value);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        target = new ReplicationTarget("peer2", "5", "5");
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        target = new ReplicationTarget("peer3", "5", "5");
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)builder.setClosed(false).build()));
        replBw.addMutation(m);
        replBw.flush();
        Assert.assertEquals((long)(numRecords += 4), (long)Iterables.size((Iterable)ReplicationTable.getScanner((Connector)this.conn)));
        BatchScanner bs = ReplicationTable.getBatchScanner((Connector)this.conn, (int)1);
        bs.setRanges(Collections.singleton(new Range()));
        IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
        bs.addScanIterator(cfg);
        try {
            Assert.assertEquals((long)0L, (long)this.rcrr.removeCompleteRecords(this.conn, bs, replBw));
        }
        finally {
            bs.close();
            replBw.close();
        }
    }

    private static class MockRemoveCompleteReplicationRecords
    extends RemoveCompleteReplicationRecords {
        public MockRemoveCompleteReplicationRecords(Connector conn) {
            super(conn);
        }

        public long removeCompleteRecords(Connector conn, BatchScanner bs, BatchWriter bw) {
            return super.removeCompleteRecords(conn, bs, bw);
        }
    }
}

