/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle;

import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;

public class RangeSerialization {
    private static final Text EMPTY = new Text(new byte[0]);

    public static Range toRange(Key key) {
        Text holder = new Text();
        key.getRow(holder);
        Key startKey = 0 == holder.getLength() ? null : new Key(holder);
        key.getColumnQualifier(holder);
        Key endKey = 0 == holder.getLength() ? null : new Key(holder);
        return new Range(startKey, startKey != null, endKey, endKey != null);
    }

    public static Key toKey(Range range) {
        Text row = RangeSerialization.getRow(range);
        return new Key(row, EMPTY, RangeSerialization.getColumnQualifier(range));
    }

    public static Mutation toMutation(Range range, Value v) {
        Text row = RangeSerialization.getRow(range);
        Mutation m = new Mutation(row);
        m.put(EMPTY, RangeSerialization.getColumnQualifier(range), v);
        return m;
    }

    public static Text getRow(Range range) {
        return range.isInfiniteStartKey() ? EMPTY : range.getStartKey().getRow();
    }

    public static Text getColumnQualifier(Range range) {
        return range.isInfiniteStopKey() ? EMPTY : range.getEndKey().getRow();
    }
}

