/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle.cli;

import com.beust.jcommander.Parameter;
import java.io.FileNotFoundException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.test.replication.merkle.cli.ComputeRootHash;
import org.apache.accumulo.test.replication.merkle.cli.GenerateHashes;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareTables {
    private static final Logger log = LoggerFactory.getLogger(CompareTables.class);
    private CompareTablesOpts opts;

    protected CompareTables() {
    }

    public CompareTables(CompareTablesOpts opts) {
        this.opts = opts;
    }

    public Map<String, String> computeAllHashes() throws AccumuloException, AccumuloSecurityException, TableExistsException, NoSuchAlgorithmException, TableNotFoundException, FileNotFoundException {
        Connector conn = this.opts.getConnector();
        HashMap<String, String> hashesByTable = new HashMap<String, String>();
        for (String table : this.opts.getTables()) {
            String outputTableName = table + "_merkle";
            if (conn.tableOperations().exists(outputTableName)) {
                throw new IllegalArgumentException("Expected output table name to not yet exist: " + outputTableName);
            }
            conn.tableOperations().create(outputTableName);
            GenerateHashes genHashes = new GenerateHashes();
            Collection<Range> ranges = genHashes.getRanges(this.opts.getConnector(), table, this.opts.getSplitsFile());
            try {
                genHashes.run(this.opts.getConnector(), table, table + "_merkle", this.opts.getHashName(), this.opts.getNumThreads(), this.opts.isIteratorPushdown(), ranges);
            }
            catch (Exception e) {
                log.error("Error generating hashes for {}", (Object)table, (Object)e);
                throw new RuntimeException(e);
            }
            ComputeRootHash computeRootHash = new ComputeRootHash();
            String hash = Hex.encodeHexString((byte[])computeRootHash.getHash(conn, outputTableName, this.opts.getHashName()));
            hashesByTable.put(table, hash);
        }
        return hashesByTable;
    }

    public static void main(String[] args) throws Exception {
        CompareTablesOpts opts = new CompareTablesOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs("CompareTables", args, new Object[]{bwOpts});
        if (opts.isIteratorPushdown() && null != opts.getSplitsFile()) {
            throw new IllegalArgumentException("Cannot use iterator pushdown with anything other than table split points");
        }
        CompareTables compareTables = new CompareTables(opts);
        Map<String, String> tableToHashes = compareTables.computeAllHashes();
        boolean hashesEqual = true;
        String previousHash = null;
        for (Map.Entry<String, String> entry : tableToHashes.entrySet()) {
            if (null == previousHash) {
                previousHash = entry.getValue();
            } else if (hashesEqual) {
                hashesEqual = previousHash.equals(entry.getValue());
            }
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
        System.exit(hashesEqual ? 0 : 1);
    }

    public static class CompareTablesOpts
    extends ClientOpts {
        @Parameter(names={"--tables"}, description="Tables to compare", variableArity=true)
        public List<String> tables;
        @Parameter(names={"-nt", "--numThreads"}, required=false, description="number of concurrent threads calculating digests")
        private int numThreads = 4;
        @Parameter(names={"-hash", "--hash"}, required=true, description="type of hash to use")
        private String hashName;
        @Parameter(names={"-iter", "--iterator"}, required=false, description="Should pushdown digest to iterators")
        private boolean iteratorPushdown = false;
        @Parameter(names={"-s", "--splits"}, required=false, description="File of splits to use for merkle tree")
        private String splitsFile = null;

        public List<String> getTables() {
            return this.tables;
        }

        public void setTables(List<String> tables) {
            this.tables = tables;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public void setNumThreads(int numThreads) {
            this.numThreads = numThreads;
        }

        public String getHashName() {
            return this.hashName;
        }

        public void setHashName(String hashName) {
            this.hashName = hashName;
        }

        public boolean isIteratorPushdown() {
            return this.iteratorPushdown;
        }

        public void setIteratorPushdown(boolean iteratorPushdown) {
            this.iteratorPushdown = iteratorPushdown;
        }

        public String getSplitsFile() {
            return this.splitsFile;
        }

        public void setSplitsFile(String splitsFile) {
            this.splitsFile = splitsFile;
        }
    }
}

