/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.start;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.file.rfile.PrintInfo;
import org.apache.accumulo.core.util.Classpath;
import org.apache.accumulo.core.util.CreateToken;
import org.apache.accumulo.core.util.Help;
import org.apache.accumulo.core.util.Jar;
import org.apache.accumulo.core.util.Version;
import org.apache.accumulo.gc.GCExecutable;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.MasterExecutable;
import org.apache.accumulo.minicluster.MiniAccumuloRunner;
import org.apache.accumulo.minicluster.impl.MiniClusterExecutable;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.MonitorExecutable;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.server.conf.ConfigSanityCheck;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.server.util.Info;
import org.apache.accumulo.server.util.LoginProperties;
import org.apache.accumulo.server.util.ZooKeeperMain;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.accumulo.tracer.TracerExecutable;
import org.apache.accumulo.tserver.TServerExecutable;
import org.apache.accumulo.tserver.TabletServer;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SunnyDayTests.class})
public class KeywordStartIT {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Test
    public void testKeywordsMatch() throws IOException {
        for (Map.Entry entry : Main.getExecutables((ClassLoader)this.getClass().getClassLoader()).entrySet()) {
            Assert.assertEquals(entry.getKey(), (Object)((KeywordExecutable)entry.getValue()).keyword());
        }
    }

    @Test
    public void testCheckDuplicates() {
        NoOp one = new NoOp("one");
        NoOp anotherOne = new NoOp("another");
        NoOp two = new NoOp("two");
        NoOp three = new NoOp("three");
        List<NoOp> services = Arrays.asList(one, three, two, two, three, three, anotherOne);
        Assert.assertEquals((long)7L, (long)services.size());
        Map results = Main.checkDuplicates(services);
        Assert.assertTrue((boolean)results.containsKey(one.keyword()));
        Assert.assertTrue((boolean)results.containsKey(anotherOne.keyword()));
        Assert.assertFalse((boolean)results.containsKey(two.keyword()));
        Assert.assertFalse((boolean)results.containsKey(three.keyword()));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testExpectedClasses() throws IOException {
        Assume.assumeTrue((boolean)new File(System.getProperty("user.dir") + "/src").exists());
        TreeMap<String, Class> expectSet = new TreeMap<String, Class>();
        expectSet.put("admin", Admin.class);
        expectSet.put("check-server-config", ConfigSanityCheck.class);
        expectSet.put("classpath", Classpath.class);
        expectSet.put("create-token", CreateToken.class);
        expectSet.put("gc", GCExecutable.class);
        expectSet.put("help", Help.class);
        expectSet.put("info", Info.class);
        expectSet.put("init", Initialize.class);
        expectSet.put("jar", Jar.class);
        expectSet.put("login-info", LoginProperties.class);
        expectSet.put("master", MasterExecutable.class);
        expectSet.put("minicluster", MiniClusterExecutable.class);
        expectSet.put("monitor", MonitorExecutable.class);
        expectSet.put("proxy", Proxy.class);
        expectSet.put("rfile-info", PrintInfo.class);
        expectSet.put("shell", Shell.class);
        expectSet.put("tracer", TracerExecutable.class);
        expectSet.put("tserver", TServerExecutable.class);
        expectSet.put("version", Version.class);
        expectSet.put("zookeeper", ZooKeeperMain.class);
        Iterator expectIter = expectSet.entrySet().iterator();
        TreeMap actualSet = new TreeMap(Main.getExecutables((ClassLoader)this.getClass().getClassLoader()));
        Iterator actualIter = actualSet.entrySet().iterator();
        while (expectIter.hasNext() && actualIter.hasNext()) {
            Map.Entry expected = expectIter.next();
            Map.Entry actual = actualIter.next();
            Assert.assertEquals(expected.getKey(), actual.getKey());
            Assert.assertEquals(expected.getValue(), ((KeywordExecutable)actual.getValue()).getClass());
        }
        boolean moreExpected = expectIter.hasNext();
        if (moreExpected) {
            while (expectIter.hasNext()) {
                this.log.warn("Missing class for keyword '" + expectIter.next() + "'");
            }
        }
        Assert.assertFalse((String)"Missing expected classes", (boolean)moreExpected);
        boolean moreActual = actualIter.hasNext();
        if (moreActual) {
            while (actualIter.hasNext()) {
                this.log.warn("Extra class found with keyword '" + actualIter.next() + "'");
            }
        }
        Assert.assertFalse((String)"Found additional unexpected classes", (boolean)moreActual);
    }

    @Test
    public void checkHasMain() {
        Assert.assertFalse((String)"Sanity check for test failed. Somehow the test class has a main method", (boolean)KeywordStartIT.hasMain(this.getClass()));
        HashSet<Class<ZooKeeperMain>> expectSet = new HashSet<Class<ZooKeeperMain>>();
        expectSet.add(Admin.class);
        expectSet.add(CreateToken.class);
        expectSet.add(Info.class);
        expectSet.add(Initialize.class);
        expectSet.add(LoginProperties.class);
        expectSet.add(Master.class);
        expectSet.add(MiniAccumuloRunner.class);
        expectSet.add(Monitor.class);
        expectSet.add(PrintInfo.class);
        expectSet.add(Proxy.class);
        expectSet.add(Shell.class);
        expectSet.add(SimpleGarbageCollector.class);
        expectSet.add(TabletServer.class);
        expectSet.add(TraceServer.class);
        expectSet.add(ZooKeeperMain.class);
        for (Class clazz : expectSet) {
            Assert.assertTrue((String)("Class " + clazz.getName() + " is missing a main method!"), (boolean)KeywordStartIT.hasMain(clazz));
        }
    }

    private static boolean hasMain(Class<?> classToCheck) {
        Method main;
        try {
            main = classToCheck.getMethod("main", new String[0].getClass());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return main != null && Modifier.isPublic(main.getModifiers()) && Modifier.isStatic(main.getModifiers());
    }

    private static class NoOp
    implements KeywordExecutable {
        private final String kw;

        public NoOp(String kw) {
            this.kw = kw;
        }

        public String keyword() {
            return this.kw;
        }

        public void execute(String[] args) throws Exception {
        }
    }
}

