/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.celltypes;

import org.apache.accumulo.core.util.NumUtil;
import org.apache.accumulo.monitor.util.celltypes.CellType;

public class NumberType<T extends Number>
extends CellType<T> {
    private static final long serialVersionUID = 1L;
    protected final T warnMin;
    protected final T warnMax;
    protected final T errMin;
    protected final T errMax;

    public NumberType(T warnMin, T warnMax, T errMin, T errMax) {
        this.warnMin = warnMin;
        this.warnMax = warnMax;
        this.errMin = errMin;
        this.errMax = errMax;
    }

    public NumberType(T errMin, T errMax) {
        this(null, null, errMin, errMax);
    }

    public NumberType() {
        this(null, null);
    }

    @Override
    public String format(Object obj) {
        Number number = (Number)obj;
        String s = "-";
        if (number instanceof Double || number instanceof Float) {
            s = this.warnMin != null && this.warnMax != null && this.errMin != null && this.errMax != null ? NumberType.commas(number.doubleValue(), ((Number)this.warnMin).doubleValue(), ((Number)this.warnMax).doubleValue(), ((Number)this.errMin).doubleValue(), ((Number)this.errMax).doubleValue()) : (this.errMin != null && this.errMax != null ? NumberType.commas(number.doubleValue(), ((Number)this.errMin).doubleValue(), ((Number)this.errMax).doubleValue()) : NumberType.commas(number.doubleValue()));
        } else if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            s = this.warnMin != null && this.warnMax != null && this.errMin != null && this.errMax != null ? NumberType.commas(number.longValue(), ((Number)this.warnMin).longValue(), ((Number)this.warnMax).longValue(), ((Number)this.errMin).longValue(), ((Number)this.errMax).longValue()) : (this.errMin != null && this.errMax != null ? NumberType.commas(number.longValue(), ((Number)this.errMin).longValue(), ((Number)this.errMax).longValue()) : NumberType.commas(number.longValue()));
        } else if (number != null) {
            s = String.valueOf(number);
        }
        return s;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
    }

    public static String commas(long i) {
        return NumUtil.bigNumberForQuantity((long)i);
    }

    public static String commas(long i, long errMin, long errMax) {
        if (i < errMin || i > errMax) {
            return String.format("<span class='error'>%s</span>", NumUtil.bigNumberForQuantity((long)i));
        }
        return NumUtil.bigNumberForQuantity((long)i);
    }

    public static String commas(double i) {
        return NumUtil.bigNumberForQuantity((long)((long)i));
    }

    public static String commas(double d, double errMin, double errMax) {
        if (d < errMin || d > errMax) {
            return String.format("<span class='error'>%s</span>", NumUtil.bigNumberForQuantity((double)d));
        }
        return NumUtil.bigNumberForQuantity((double)d);
    }

    public static String commas(long i, long warnMin, long warnMax, long errMin, long errMax) {
        if (i < errMin || i > errMax) {
            return String.format("<span class='error'>%s</span>", NumUtil.bigNumberForQuantity((long)i));
        }
        if (i < warnMin || i > warnMax) {
            return String.format("<span class='warning'>%s</span>", NumUtil.bigNumberForQuantity((long)i));
        }
        return NumUtil.bigNumberForQuantity((long)i);
    }

    public static String commas(double d, double warnMin, double warnMax, double errMin, double errMax) {
        if (d < errMin || d > errMax) {
            return String.format("<span class='error'>%s</span>", NumUtil.bigNumberForQuantity((double)d));
        }
        if (d < warnMin || d > warnMax) {
            return String.format("<span class='warning'>%s</span>", NumUtil.bigNumberForQuantity((double)d));
        }
        return NumUtil.bigNumberForQuantity((double)d);
    }

    @Override
    public String alignment() {
        return "right";
    }
}

