/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.server.metrics.NoopMetrics;

public class ScanServerMetrics
implements MetricsProducer {
    private Timer totalReservationTimer = NoopMetrics.useNoopTimer();
    private Timer writeOutReservationTimer = NoopMetrics.useNoopTimer();
    private Counter busyTimeoutCount = NoopMetrics.useNoopCounter();
    private final AtomicLong reservationConflictCount = new AtomicLong(0L);
    private final LoadingCache<KeyExtent, TabletMetadata> tabletMetadataCache;

    public ScanServerMetrics(LoadingCache<KeyExtent, TabletMetadata> tabletMetadataCache) {
        this.tabletMetadataCache = tabletMetadataCache;
    }

    public void registerMetrics(MeterRegistry registry) {
        this.totalReservationTimer = Timer.builder((String)"accumulo.scan.reservation.total.timer").description("Time to reserve a tablets files for scan").register(registry);
        this.writeOutReservationTimer = Timer.builder((String)"accumulo.scan.reservation.writeout.timer").description("Time to write out a tablets file reservations for scan").register(registry);
        this.busyTimeoutCount = Counter.builder((String)"accumulo.scan.busy.timeout.count").description("The number of scans where a busy timeout happened").register(registry);
        FunctionCounter.builder((String)"accumulo.scan.reservation.conflict.count", (Object)this.reservationConflictCount, AtomicLong::get).description("Counts instances where file reservation attempts for scans encountered conflicts").register(registry);
        if (this.tabletMetadataCache != null) {
            Preconditions.checkState((boolean)this.tabletMetadataCache.policy().isRecordingStats(), (Object)"Attempted to instrument cache that is not recording stats.");
            CaffeineCacheMetrics.monitor((MeterRegistry)registry, this.tabletMetadataCache, (String)"accumulo.scan.tablet.metadata.cache", (String[])new String[0]);
        }
    }

    public void recordTotalReservationTime(Duration time) {
        this.totalReservationTimer.record(time);
    }

    public void recordWriteOutReservationTime(Runnable time) {
        this.writeOutReservationTimer.record(time);
    }

    public void incrementBusy() {
        this.busyTimeoutCount.increment();
    }

    public void incrementReservationConflictCount() {
        this.reservationConflictCount.getAndIncrement();
    }
}

