/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.replication;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.tserver.replication.ReplicationProcessor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ReplicationWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReplicationWorker.class);
    private final AbstractServer server;
    private ThreadPoolExecutor executor;

    public ReplicationWorker(AbstractServer server) {
        this.server = server;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void run() {
        DefaultConfiguration defaultConf = DefaultConfiguration.getInstance();
        long defaultDelay = defaultConf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_DELAY);
        long defaultPeriod = defaultConf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_PERIOD);
        AccumuloConfiguration conf = this.server.getConfiguration();
        long delay = conf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_DELAY);
        long period = conf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_PERIOD);
        try {
            DistributedWorkQueue workQueue;
            if (defaultDelay != delay && defaultPeriod != period) {
                log.debug("Configuration DistributedWorkQueue with delay and period of {} and {}", (Object)delay, (Object)period);
                workQueue = new DistributedWorkQueue(this.server.getContext().getZooKeeperRoot() + "/replication/workqueue", conf, this.server, delay, period);
            } else {
                log.debug("Configuring DistributedWorkQueue with default delay and period");
                workQueue = new DistributedWorkQueue(this.server.getContext().getZooKeeperRoot() + "/replication/workqueue", conf, this.server);
            }
            workQueue.startProcessing((DistributedWorkQueue.Processor)new ReplicationProcessor(this.server.getContext()), this.executor);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }
}

