/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.List;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqSketch;

public class ReqSketchIterator
implements QuantilesFloatsSketchIterator {
    private List<ReqCompactor> compactors;
    private int cIndex;
    private int bIndex;
    private int numRetainedItems;
    private FloatBuffer currentBuf;

    ReqSketchIterator(ReqSketch sketch) {
        this.compactors = sketch.getCompactors();
        this.numRetainedItems = sketch.getNumRetained();
        this.currentBuf = this.compactors.get(0).getBuffer();
        this.cIndex = 0;
        this.bIndex = -1;
    }

    @Override
    public float getQuantile() {
        return this.currentBuf.getItem(this.bIndex);
    }

    @Override
    public long getWeight() {
        return 1 << this.cIndex;
    }

    @Override
    public boolean next() {
        if (this.numRetainedItems == 0 || this.cIndex == this.compactors.size() - 1 && this.bIndex == this.currentBuf.getCount() - 1) {
            return false;
        }
        if (this.bIndex == this.currentBuf.getCount() - 1) {
            ++this.cIndex;
            this.currentBuf = this.compactors.get(this.cIndex).getBuffer();
            this.bIndex = 0;
        } else {
            ++this.bIndex;
        }
        return true;
    }
}

