/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.monitor.Monitor;
import org.apache.commons.validator.routines.UrlValidator;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedWebServer.class);
    private static final EnumSet<Property> requireForSecure = EnumSet.of(Property.MONITOR_SSL_KEYSTORE, Property.MONITOR_SSL_KEYSTOREPASS, Property.MONITOR_SSL_TRUSTSTORE, Property.MONITOR_SSL_TRUSTSTOREPASS);
    private final Server server = new Server();
    private final ServerConnector connector;
    private final ServletContextHandler handler;
    private final boolean secure;

    public EmbeddedWebServer(Monitor monitor, int port) {
        AccumuloConfiguration conf = monitor.getContext().getConfiguration();
        this.secure = requireForSecure.stream().map(arg_0 -> ((AccumuloConfiguration)conf).get(arg_0)).allMatch(s -> s != null && !s.isEmpty());
        this.connector = new ServerConnector(this.server, (ConnectionFactory[])EmbeddedWebServer.getConnectionFactories(conf, this.secure));
        this.connector.setHost(monitor.getBindAddress());
        this.connector.setPort(port);
        this.handler = new ServletContextHandler(3);
        this.handler.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        String rootContext = monitor.getConfiguration().get(Property.MONITOR_ROOT_CONTEXT);
        String[] scheme = new String[]{"https"};
        UrlValidator validator = new UrlValidator(scheme);
        Preconditions.checkArgument((boolean)validator.isValid("https://example.com" + rootContext), (String)"Root context: \"%s\" is not a valid URL", (Object)rootContext);
        if (rootContext.length() > 1 && rootContext.endsWith("/")) {
            rootContext = rootContext.substring(0, rootContext.length() - 1);
        }
        this.handler.setContextPath(rootContext);
    }

    private static AbstractConnectionFactory[] getConnectionFactories(AccumuloConfiguration conf, boolean secure) {
        HttpConnectionFactory httpFactory = new HttpConnectionFactory();
        if (secure) {
            String includeProtocols;
            LOG.debug("Configuring Jetty to use TLS");
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            String keyPass = conf.get(Property.MONITOR_SSL_KEYPASS);
            if (!Property.MONITOR_SSL_KEYPASS.getDefaultValue().equals(keyPass)) {
                sslContextFactory.setKeyManagerPassword(keyPass);
            }
            sslContextFactory.setKeyStorePath(conf.get(Property.MONITOR_SSL_KEYSTORE));
            sslContextFactory.setKeyStorePassword(conf.get(Property.MONITOR_SSL_KEYSTOREPASS));
            sslContextFactory.setKeyStoreType(conf.get(Property.MONITOR_SSL_KEYSTORETYPE));
            sslContextFactory.setTrustStorePath(conf.get(Property.MONITOR_SSL_TRUSTSTORE));
            sslContextFactory.setTrustStorePassword(conf.get(Property.MONITOR_SSL_TRUSTSTOREPASS));
            sslContextFactory.setTrustStoreType(conf.get(Property.MONITOR_SSL_TRUSTSTORETYPE));
            String includedCiphers = conf.get(Property.MONITOR_SSL_INCLUDE_CIPHERS);
            if (!Property.MONITOR_SSL_INCLUDE_CIPHERS.getDefaultValue().equals(includedCiphers)) {
                sslContextFactory.setIncludeCipherSuites(includedCiphers.split(","));
            }
            String excludedCiphers = conf.get(Property.MONITOR_SSL_EXCLUDE_CIPHERS);
            if (!Property.MONITOR_SSL_EXCLUDE_CIPHERS.getDefaultValue().equals(excludedCiphers)) {
                sslContextFactory.setExcludeCipherSuites(excludedCiphers.split(","));
            }
            if ((includeProtocols = conf.get(Property.MONITOR_SSL_INCLUDE_PROTOCOLS)) != null && !includeProtocols.isEmpty()) {
                sslContextFactory.setIncludeProtocols(includeProtocols.split(","));
            }
            SslConnectionFactory sslFactory = new SslConnectionFactory(sslContextFactory, httpFactory.getProtocol());
            return new AbstractConnectionFactory[]{sslFactory, httpFactory};
        }
        LOG.debug("Not configuring Jetty to use TLS");
        return new AbstractConnectionFactory[]{httpFactory};
    }

    public void addServlet(ServletHolder restServlet, String where) {
        this.handler.addServlet(restServlet, where);
    }

    @VisibleForTesting
    String getContextPath() {
        return this.handler.getContextPath();
    }

    public String getHostName() {
        return this.connector.getHost();
    }

    public int getPort() {
        return this.connector.getLocalPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void start() {
        try {
            this.server.addConnector((Connector)this.connector);
            this.server.setHandler((Handler)this.handler);
            this.server.start();
        }
        catch (Exception e) {
            this.stop();
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
            this.server.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }
}

